/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.references.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.references.Activator;
import org.eclipse.papyrus.views.references.Messages;
import org.eclipse.papyrus.views.references.actions.GoToAction;
import org.eclipse.papyrus.views.references.providers.ReferencesHeaderLabelProvider;
import org.eclipse.papyrus.views.references.providers.ReferencesResultContentProvider;
import org.eclipse.papyrus.views.references.providers.ReferencesResultLabelProvider;
import org.eclipse.papyrus.views.references.utils.HandleReferences;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ReferencesView
extends ViewPart {
    public static final String ID = "org.eclipse.papyrus.views.references.ReferencesView";
    private static final ImageDescriptor COLLAPSE_ALL_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.search", (String)"icons/full/elcl16/collapseall.gif");
    private static final ImageDescriptor EXPAND_ALL_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.search", (String)"icons/full/elcl16/expandall.gif");
    private static final ImageDescriptor REFRESH_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.search", (String)"icons/full/elcl16/refresh.gif");
    private static final ImageDescriptor CLEAR_ALL_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.search", (String)"icons/full/elcl16/search_remall.gif");
    private static final ImageDescriptor LINK_WITH_EDITOR_IMAGE_DESCRIPTOR = Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/elcl16/synced.png");
    private TreeViewer treeViewerReferences;
    private ReferencesResultLabelProvider labelResultProvider;
    private ReferencesHeaderLabelProvider headerLabelProvider;
    private boolean linkingEnabled;
    private ISelectionListener editorSelectionListener;
    private FormToolkit toolkit;
    private ScrolledForm scrolledForm;
    private Label multiSelectionLabel;
    private StackLayout stackLayout;
    private GoToAction goToAction;
    private ISelection oldSelection;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.linkingEnabled = true;
        this.editorSelectionListener = this.createSelectionListener();
        site.getPage().addSelectionListener(this.editorSelectionListener);
    }

    private ISelectionListener createSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!(part instanceof ReferencesView)) {
                    ReferencesView.this.oldSelection = selection;
                    if (ReferencesView.this.linkingEnabled) {
                        ReferencesView.this.searchSelectionReferences(selection);
                    }
                }
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.linkingEnabled = Activator.getDefault().getToogleLinkingSetting();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.scrolledForm = this.toolkit.createScrolledForm(parent);
        this.scrolledForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 5;
        body.setLayout((Layout)this.stackLayout);
        this.createTreeViewerReferences(body);
        this.stackLayout.topControl = this.treeViewerReferences.getTree();
        this.multiSelectionLabel = this.toolkit.createLabel(body, Messages.ReferencesView_MultiSelection);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewerReferences);
        this.createActions();
        this.createContextMenu();
        this.scrolledForm.setVisible(false);
    }

    private void createTreeViewerReferences(Composite parent) {
        this.treeViewerReferences = new TreeViewer(parent, 0);
        this.treeViewerReferences.setContentProvider((IContentProvider)new ReferencesResultContentProvider());
        this.treeViewerReferences.setLabelProvider((IBaseLabelProvider)this.getResultLabelProvider());
        this.treeViewerReferences.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ReferencesView.this.goToAction.run();
            }
        });
    }

    private final ReferencesResultLabelProvider getResultLabelProvider() {
        if (this.labelResultProvider == null) {
            this.labelResultProvider = new ReferencesResultLabelProvider();
        }
        return this.labelResultProvider;
    }

    private ReferencesHeaderLabelProvider getHeaderLabelProvider() {
        if (this.headerLabelProvider == null) {
            this.headerLabelProvider = new ReferencesHeaderLabelProvider();
        }
        return this.headerLabelProvider;
    }

    private void createActions() {
        this.goToAction = new GoToAction();
        this.treeViewerReferences.addSelectionChangedListener((ISelectionChangedListener)this.goToAction);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add(this.createClearAllAction());
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add(this.createRefreshAction());
            toolBarManager.add(this.createToggleLinkingAction());
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add(this.createExpandAllAction());
            toolBarManager.add(this.createCollapseAllAction());
        }
    }

    private IAction createToggleLinkingAction() {
        Action toggleLinkingAction = new Action(Messages.ReferencesView_LinkWithEditorLabel, 2){

            public void run() {
                ReferencesView.this.linkingEnabled = this.isChecked();
                Activator.getDefault().setToggleEditorSetting(ReferencesView.this.linkingEnabled);
                if (this.isChecked() && ReferencesView.this.oldSelection != null) {
                    ReferencesView.this.searchSelectionReferences(ReferencesView.this.oldSelection);
                }
            }
        };
        toggleLinkingAction.setChecked(this.linkingEnabled);
        toggleLinkingAction.setImageDescriptor(LINK_WITH_EDITOR_IMAGE_DESCRIPTOR);
        return toggleLinkingAction;
    }

    private IAction createExpandAllAction() {
        Action expandAllAction = new Action(Messages.ReferencesView_ExpandAllLabel, EXPAND_ALL_IMAGE_DESCRIPTOR){

            public void run() {
                if (ReferencesView.this.treeViewerReferences != null) {
                    ReferencesView.this.treeViewerReferences.expandAll();
                }
            }
        };
        return expandAllAction;
    }

    private IAction createCollapseAllAction() {
        Action collapseAllAction = new Action(Messages.ReferencesView_CollapseAllLabel, COLLAPSE_ALL_IMAGE_DESCRIPTOR){

            public void run() {
                if (ReferencesView.this.treeViewerReferences != null) {
                    ReferencesView.this.treeViewerReferences.collapseAll();
                }
            }
        };
        return collapseAllAction;
    }

    private IAction createRefreshAction() {
        Action refreshAction = new Action(Messages.ReferencesView_RefreshLabel, REFRESH_IMAGE_DESCRIPTOR){

            public void run() {
                if (ReferencesView.this.oldSelection != null) {
                    ReferencesView.this.searchSelectionReferences(ReferencesView.this.oldSelection);
                }
            }
        };
        return refreshAction;
    }

    private IAction createClearAllAction() {
        Action clearAllAction = new Action(Messages.ReferencesView_ClearAllLabel, CLEAR_ALL_IMAGE_DESCRIPTOR){

            public void run() {
                ReferencesView.this.clearView();
            }
        };
        return clearAllAction;
    }

    private void clearView() {
        if (this.scrolledForm != null) {
            this.scrolledForm.setVisible(false);
        }
        if (this.treeViewerReferences != null) {
            this.treeViewerReferences.setInput(null);
            this.changeStackLayoutTopControl((Control)this.treeViewerReferences.getTree());
        }
    }

    private void changeStackLayoutTopControl(Control topControl) {
        if (this.stackLayout.topControl != topControl) {
            this.stackLayout.topControl = topControl;
            this.scrolledForm.getBody().layout(true);
        }
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ReferencesView.this.goToAction);
            }
        });
        Menu menu = contextMenu.createContextMenu(this.treeViewerReferences.getControl());
        this.treeViewerReferences.getControl().setMenu(menu);
        this.getSite().registerContextMenu(ID, contextMenu, (ISelectionProvider)this.treeViewerReferences);
    }

    public void showResult(Object references, Object object) {
        if (this.scrolledForm != null && !this.scrolledForm.isDisposed()) {
            String objectName = this.getHeaderLabelProvider().getText(object);
            this.scrolledForm.setText(objectName != null ? objectName : "<empty>");
            this.scrolledForm.setImage(this.getHeaderLabelProvider().getImage(object));
            this.scrolledForm.setVisible(true);
        }
        if (this.treeViewerReferences != null && !this.treeViewerReferences.getTree().isDisposed()) {
            this.treeViewerReferences.setInput(references);
            this.treeViewerReferences.expandAll();
            this.changeStackLayoutTopControl((Control)this.treeViewerReferences.getTree());
        }
    }

    private void searchSelectionReferences(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (1 == structuredSelection.size()) {
                Object firstElement = structuredSelection.getFirstElement();
                EObject eObjectToSearch = EMFHelper.getEObject((Object)firstElement);
                if (eObjectToSearch != null) {
                    HandleReferences.INSTANCE.getViewAndLaunch(eObjectToSearch);
                }
            } else if (1 < structuredSelection.size()) {
                this.scrolledForm.setText("N/A");
                this.scrolledForm.setImage(null);
                this.changeStackLayoutTopControl((Control)this.multiSelectionLabel);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.editorSelectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.editorSelectionListener);
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    public void setFocus() {
    }
}

