/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.ui.widgets.SessionComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenSessionDialog
extends TitleAreaDialog {
    public static final String TITLE = Messages.getString("OpenSessionDialog.0");
    private static final int WIDTH = 380;
    private static final int HEIGHT = 240;
    private IWorkbenchPage page;
    private SessionComposite sessionComposite;

    public OpenSessionDialog(IWorkbenchPage page) {
        super(page.getWorkbenchWindow().getShell());
        this.page = page;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public SessionComposite getSessionComposite() {
        return this.sessionComposite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
        Rectangle bounds = this.page.getWorkbenchWindow().getShell().getBounds();
        int x = bounds.x + (bounds.width - 380) / 2;
        int y = bounds.y + (bounds.height - 240) / 2;
        newShell.setBounds(x, y, 380, 240);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setTitleImage(SharedIcons.getImage((String)"wizban/OpenSession.gif"));
        this.setMessage(Messages.getString("OpenSessionDialog.1"));
        this.sessionComposite = new SessionComposite(parent, 0);
        return this.sessionComposite;
    }

    protected void okPressed() {
        this.sessionComposite.rememberSettings();
        super.okPressed();
    }
}

