/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.history.HistoryModel;
import org.eclipse.papyrus.infra.services.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.infra.services.resourceloading.ControledResourceAdapter;
import org.eclipse.papyrus.infra.services.resourceloading.HistoryRoutingUtils;
import org.eclipse.papyrus.infra.services.resourceloading.IProxyManager;

public class HistoryRoutingManager {
    private ControledResourceAdapter adapter;
    private final IProxyManager proxyManager;

    public HistoryRoutingManager(IProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    public EObject getEObject(ModelSet modelSet, String resourceURI, String fragment) {
        List<ControledResource> res;
        this.adapter = HistoryRoutingUtils.getControledResourceAdapter(modelSet);
        EObject result = null;
        HistoryModel historyModel = HistoryUtils.getHistoryModel((ModelSet)modelSet);
        if (historyModel != null && (res = this.adapter.getControledResource(resourceURI)) != null) {
            block0: for (ControledResource controled : res) {
                for (ControledResource child : controled.getChildren()) {
                    URI locationURI = URI.createURI((String)child.getResourceURL());
                    URI toGet = locationURI.resolve(HistoryUtils.getURIFullPath((URI)child.eResource().getURI()));
                    Resource resource = modelSet.getResource(toGet, this.proxyManager.loadResource(locationURI));
                    if (resource != null && ((result = resource.getEObject(fragment)) != null || (result = this.getEObject(modelSet, child.getResourceURL(), fragment)) != null)) continue block0;
                }
            }
        }
        return result;
    }

    public void unload() {
        if (this.adapter != null) {
            Notifier resSet = this.adapter.getTarget();
            resSet.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
        }
    }
}

