/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ZipFileStructureProvider
implements IImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map<ZipEntry, List<ZipEntry>> children;
    private Map<IPath, ZipEntry> directoryEntryCache = new HashMap<IPath, ZipEntry>();
    private Set<String> invalidEntries = new HashSet<String>();

    public ZipFileStructureProvider(ZipFile sourceFile) {
        this.zipFile = sourceFile;
    }

    protected void addToChildren(ZipEntry parent, ZipEntry child) {
        List<ZipEntry> childList = this.children.get(parent);
        if (childList == null) {
            childList = new ArrayList<ZipEntry>();
            this.children.put(parent, childList);
        }
        childList.add(child);
    }

    protected void createContainer(IPath pathname) {
        if (this.directoryEntryCache.containsKey(pathname)) {
            return;
        }
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        ZipEntry newEntry = new ZipEntry(pathname.toString());
        this.directoryEntryCache.put(pathname, newEntry);
        this.addToChildren(parent, newEntry);
    }

    protected void createFile(ZipEntry entry) {
        Path pathname = new Path(entry.getName());
        ZipEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        this.addToChildren(parent, entry);
    }

    @Override
    public List<?> getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    @Override
    public InputStream getContents(Object element) {
        try {
            if (this.invalidEntries.contains(((ZipEntry)element).getName())) {
                throw new IOException("Cannot get content of Entry as it is outside of the target dir: " + ((ZipEntry)element).getName());
            }
            return this.zipFile.getInputStream((ZipEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    @Override
    public String getFullPath(Object element) {
        return ((ZipEntry)element).getName();
    }

    @Override
    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((ZipEntry)element).getName();
        }
        return new Path(((ZipEntry)element).getName()).lastSegment();
    }

    public ZipEntry getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void initialize() {
        this.children = new HashMap<ZipEntry, List<ZipEntry>>(1000);
        IPath zipFileDirPath = new Path(this.zipFile.getName()).removeLastSegments(1);
        String canonicalDestinationDirPath = zipFileDirPath.toString();
        File zipDestinationDir = new File(zipFileDirPath.toString());
        try {
            canonicalDestinationDirPath = zipDestinationDir.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            try {
                ZipEntry entry = entries.nextElement();
                File destinationfile = new File(zipDestinationDir, entry.getName());
                String canonicalDestinationFile = destinationfile.getCanonicalPath();
                if (!canonicalDestinationFile.startsWith(String.valueOf(canonicalDestinationDirPath) + File.separator)) {
                    this.invalidEntries.add(entry.getName());
                    throw new IOException("Entry is outside of the target dir: " + entry.getName());
                }
                if (entry.isDirectory()) continue;
                IPath path = new Path(entry.getName()).addTrailingSeparator();
                int pathSegmentCount = path.segmentCount();
                int i = 1;
                while (i < pathSegmentCount) {
                    this.createContainer(path.uptoSegment(i));
                    ++i;
                }
                this.createFile(entry);
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public boolean isFolder(Object element) {
        return ((ZipEntry)element).isDirectory();
    }
}

