/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;

public class JDIDebugOptions
implements DebugOptionsListener {
    public static final String DEBUG_AST_EVALUATIONS_CALLING_THREADS_FLAG = "org.eclipse.jdt.debug/debug/astEvaluations/callingThreads";
    public static final String DEBUG_AST_EVALUATIONS_FLAG = "org.eclipse.jdt.debug/debug/astEvaluations";
    public static final String DEBUG_JDI_REQUEST_TIMES_FLAG = "org.eclipse.jdt.debug/debug/jdiRequestTimes";
    public static final String DEBUG_JDI_EVENTS_FLAG = "org.eclipse.jdt.debug/debug/jdiEvents";
    public static final String DEBUG_FLAG = "org.eclipse.jdt.debug/debug";
    public static boolean DEBUG = false;
    public static boolean DEBUG_JDI_EVENTS = false;
    public static boolean DEBUG_JDI_REQUEST_TIMES = false;
    public static boolean DEBUG_AST_EVAL = false;
    public static boolean DEBUG_AST_EVAL_THREAD_TRACE = false;
    private static DebugTrace fgDebugTrace;
    public static final DateFormat FORMAT;

    static {
        FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public JDIDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", JDIDebugPlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fgDebugTrace = options.newDebugTrace(JDIDebugPlugin.getUniqueIdentifier());
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        DEBUG_JDI_EVENTS = DEBUG && options.getBooleanOption(DEBUG_JDI_EVENTS_FLAG, false);
        DEBUG_JDI_REQUEST_TIMES = DEBUG && options.getBooleanOption(DEBUG_JDI_REQUEST_TIMES_FLAG, false);
        DEBUG_AST_EVAL = DEBUG && options.getBooleanOption(DEBUG_AST_EVALUATIONS_FLAG, false);
        DEBUG_AST_EVAL_THREAD_TRACE = DEBUG && options.getBooleanOption(DEBUG_AST_EVALUATIONS_CALLING_THREADS_FLAG, false);
    }

    public static void trace(String option, String message, Throwable throwable) {
        System.out.println(message);
        if (fgDebugTrace != null) {
            fgDebugTrace.trace(option, message, throwable);
        }
    }

    public static void trace(String message) {
        JDIDebugOptions.trace(null, message, null);
    }
}

