/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.internal.migrator.CDOMigratorUtil;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

public class GenerateModelTask
extends CDOTask {
    private static final Set<ProjectType> ALL_PROJECT_TYPES = new LinkedHashSet<ProjectType>(Arrays.asList(ProjectType.model, ProjectType.edit, ProjectType.editor, ProjectType.tests));
    private final List<Input> inputs = new ArrayList<Input>();
    private final List<Output> outputs = new ArrayList<Output>();
    private boolean recursive;
    private String modelPath;
    private ProjectType projectType;

    public Input getInput(String modelPath) {
        for (Input input : this.inputs) {
            if (!input.getModelPath().equals(modelPath)) continue;
            return input;
        }
        if (Objects.equals(this.modelPath, modelPath)) {
            Input input;
            input = new Input();
            input.setModelPath(modelPath);
            return input;
        }
        return null;
    }

    public Input createInput() {
        Input input = new Input();
        this.inputs.add(input);
        return input;
    }

    public Output createOutput() {
        Output output = new Output();
        this.outputs.add(output);
        return output;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

    public void setProjectType(ProjectType projectType) {
        this.projectType = projectType;
    }

    private Set<ProjectType> getProjectTypes() {
        HashSet<ProjectType> projectTypes = new HashSet<ProjectType>();
        if (GenerateModelTask.isSet(this.outputs)) {
            for (Output output : this.outputs) {
                this.addProjectType(projectTypes, output.getProjectType());
            }
        } else {
            this.addProjectType(projectTypes, this.projectType);
        }
        return projectTypes;
    }

    private void addProjectType(Set<ProjectType> projectTypes, ProjectType projectType) {
        if (projectType == ProjectType.all) {
            projectTypes.addAll(ALL_PROJECT_TYPES);
        } else if (projectType != ProjectType.none) {
            projectTypes.add(projectType);
        }
    }

    @Override
    protected void checkAttributes() throws BuildException {
        GenerateModelTask.assertTrue("Either the 'modelPath' attribute or nested 'input' elements must be specified.", GenerateModelTask.isSet(this.modelPath) ^ GenerateModelTask.isSet(this.inputs));
        GenerateModelTask.assertTrue("Either the 'projectType' attribute or nested 'output' elements can be specified.", !GenerateModelTask.isSet(this.modelPath) || !GenerateModelTask.isSet(this.inputs));
        if (!GenerateModelTask.isSet((Object)this.projectType) && !GenerateModelTask.isSet(this.outputs)) {
            this.projectType = ProjectType.model;
        }
    }

    @Override
    protected void doExecute() throws Exception {
        if (GenerateModelTask.isSet(this.inputs)) {
            this.generate(this.inputs.stream().map(Input::getModelPath).collect(Collectors.toList()));
        } else {
            this.generate(Arrays.asList(this.modelPath));
        }
    }

    private void generate(List<String> modelPaths) throws Exception {
        long start = System.currentTimeMillis();
        int projects = 0;
        HashSet<GenModel> visited = new HashSet<GenModel>();
        BasicMonitor.Printing monitor = this.verbose ? new BasicMonitor.Printing(System.out) : BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor());
        List<GenModel> genModels = CDOMigratorUtil.getGenModels(modelPaths);
        for (GenModel genModel : genModels) {
            projects += this.generate(genModel, genModels, visited, (Monitor)monitor);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("==================================================================================");
        System.out.println("Generated " + projects + " projects for " + visited.size() + " models in " + millis + " milliseconds");
    }

    private int generate(GenModel genModel, List<GenModel> genModels, Set<GenModel> visited, Monitor monitor) throws Exception {
        int projects = 0;
        if (genModel != null && visited.add(genModel)) {
            EList usedGenPackages = genModel.getUsedGenPackages();
            if (usedGenPackages != null) {
                for (GenPackage usedGenPackage : usedGenPackages) {
                    GenModel usedGenModel = usedGenPackage.getGenModel();
                    projects += this.generate(usedGenModel, genModels, visited, monitor);
                }
            }
            if (!this.recursive && !genModels.contains(genModel)) {
                System.out.println("----------------------------------------------------------------------------------");
                System.out.println("Ignoring   " + this.modelPath);
            } else {
                URI uri = genModel.eResource().getURI();
                String modelPath = uri.toPlatformString(true);
                Input input = this.getInput(modelPath);
                Set<ProjectType> projectTypes = input == null ? this.getProjectTypes() : input.getProjectTypes();
                Generator generator = null;
                for (ProjectType projectType : ALL_PROJECT_TYPES) {
                    if (!projectTypes.contains((Object)projectType) || !GenerateModelTask.canGenerate(genModel, projectType.getDirectoryGetter())) continue;
                    if (generator == null) {
                        System.out.println("----------------------------------------------------------------------------------");
                        System.out.println("Validating " + modelPath);
                        genModel.setCanGenerate(true);
                        genModel.setValidateModel(true);
                        GenerateModelTask.validate(genModel);
                        generator = GenModelUtil.createGenerator((GenModel)genModel);
                    }
                    System.out.println("Generating " + modelPath + " (" + (Object)((Object)projectType) + " project)");
                    generator.generate((Object)genModel, (Object)projectType.getKey(), projectType.getLabel(), monitor);
                    ++projects;
                }
            }
        }
        return projects;
    }

    private static boolean canGenerate(GenModel genModel, Function<GenModel, String> directoryGetter) {
        String directory = directoryGetter.apply(genModel);
        return GenerateModelTask.isSet(directory);
    }

    private static void validate(GenModel genModel) throws DiagnosticException {
        Diagnostic diagnostic = genModel.diagnose();
        if (diagnostic != null && diagnostic.getSeverity() != 0) {
            List children = diagnostic.getChildren();
            if (children.isEmpty()) {
                System.err.println(diagnostic);
            } else {
                for (Diagnostic child : children) {
                    System.err.println(child);
                }
            }
            System.err.flush();
            throw new DiagnosticException(diagnostic);
        }
    }

    public final class Input {
        private final List<Output> outputs = new ArrayList<Output>();
        private String modelPath;
        private ProjectType projectType;

        public String getModelPath() {
            return this.modelPath;
        }

        public void setModelPath(String modelPath) {
            this.modelPath = modelPath;
        }

        public Set<ProjectType> getProjectTypes() {
            if (GenerateModelTask.isSet(this.outputs)) {
                HashSet<ProjectType> projectTypes = new HashSet<ProjectType>();
                for (Output output : this.outputs) {
                    GenerateModelTask.this.addProjectType(projectTypes, output.getProjectType());
                }
                return projectTypes;
            }
            if (GenerateModelTask.isSet((Object)this.projectType)) {
                return Collections.singleton(this.projectType);
            }
            return GenerateModelTask.this.getProjectTypes();
        }

        public ProjectType getProjectType() {
            return this.projectType;
        }

        public void setProjectType(ProjectType projectType) {
            this.projectType = projectType;
        }

        public List<Output> getOutputs() {
            return this.outputs;
        }

        public Output createOutput() {
            Output output = new Output();
            this.outputs.add(output);
            return output;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("modelPath = ");
            builder.append(this.modelPath);
            return builder.toString();
        }
    }

    public static final class Output {
        private ProjectType projectType;

        public ProjectType getProjectType() {
            return this.projectType;
        }

        public void setProjectType(ProjectType projectType) {
            this.projectType = projectType;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("projectType = ");
            builder.append((Object)this.projectType);
            return builder.toString();
        }
    }

    public static enum ProjectType {
        model("org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_ModelProject_name"), GenModel::getModelDirectory),
        edit("org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditProject_name"), GenModel::getEditDirectory),
        editor("org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_EditorProject_name"), GenModel::getEditorDirectory),
        tests("org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenEcorePlugin.INSTANCE.getString("_UI_TestsProject_name"), GenModel::getTestsDirectory),
        none(null, null, null),
        all(null, null, null);

        private final String key;
        private final String label;
        private final Function<GenModel, String> directoryGetter;

        private ProjectType(String key, String label, Function<GenModel, String> directoryGetter) {
            this.key = key;
            this.label = label;
            this.directoryGetter = directoryGetter;
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public Function<GenModel, String> getDirectoryGetter() {
            return this.directoryGetter;
        }
    }
}

