/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RepositoryPerson
implements IRepositoryPerson {
    private String name;
    private final String personId;
    private final TaskRepository taskRepository;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public RepositoryPerson(TaskRepository taskRepository, String personId) {
        this.taskRepository = taskRepository;
        this.personId = personId;
    }

    @Override
    public String getConnectorKind() {
        return this.taskRepository.getConnectorKind();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersonId() {
        return this.personId;
    }

    @Override
    public String getRepositoryUrl() {
        return this.taskRepository.getRepositoryUrl();
    }

    @Override
    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public boolean matchesUsername(String username) {
        String thisUsername = this.attributes.get("task.common.person.username");
        if (thisUsername != null) {
            return thisUsername.equals(username);
        }
        return this.getPersonId().equals(username);
    }

    public String toString() {
        if (this.getName() == null) {
            return this.getPersonId();
        }
        if (this.getPersonId() == null) {
            return this.getName();
        }
        if (this.getName().equals(this.getPersonId())) {
            return this.getName();
        }
        return String.valueOf(this.getName()) + " <" + this.getPersonId() + ">";
    }
}

