/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class EInvokeOperation
extends AbstractOperation {
    protected final @NonNull EOperation eOperation;

    public EInvokeOperation(@NonNull EOperation eOperation) {
        this.eOperation = eOperation;
        EClassifier eType = eOperation.getEType();
        if (eType == null) {
            throw new IllegalArgumentException("Non-query EOperation");
        }
    }

    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] boxedSourceAndArgumentValues) {
        TypeId returnTypeId = caller.getTypeId();
        EObject eObject = EInvokeOperation.asNavigableObject(boxedSourceAndArgumentValues[0], (Object)this.eOperation, executor);
        IdResolver idResolver = executor.getIdResolver();
        EList eParameters = this.eOperation.getEParameters();
        Object[] ecoreValues = new Object[boxedSourceAndArgumentValues.length - 1];
        int iMax = Math.min(boxedSourceAndArgumentValues.length - 1, eParameters.size());
        int i = 0;
        while (i < iMax) {
            Object argumentValue = boxedSourceAndArgumentValues[1 + i];
            EParameter eParameter = (EParameter)eParameters.get(i);
            ecoreValues[i] = idResolver.ecoreValueOf(eParameter.getEType().getInstanceClass(), argumentValue);
            ++i;
        }
        EcoreEList.UnmodifiableEList ecoreArguments = new EcoreEList.UnmodifiableEList(null, null, iMax, ecoreValues);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)ecoreArguments);
            return this.getResultValue(executor, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue(e);
        }
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() == 0) {
            return this.evaluate(executor, typeId, sourceValue, new Object[0]);
        }
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = executor.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(executor, typeId, sourceValue, firstArgument);
        }
        OCLExpression argument1 = arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = executor.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(executor, typeId, sourceValue, firstArgument, secondArgument);
        }
        @Nullable Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = executor.evaluate(argument);
            ++i;
        }
        return this.evaluate(executor, typeId, sourceValue, argumentValues);
    }

    @Deprecated
    public @Nullable Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, Object ... boxedArgumentValues) {
        return this.evaluate(EInvokeOperation.getExecutor(evaluator), returnTypeId, sourceValue, boxedArgumentValues);
    }

    @Deprecated
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, Object ... boxedArgumentValues) {
        EObject eObject = EInvokeOperation.asNavigableObject(sourceValue, (Object)this.eOperation, executor);
        IdResolver idResolver = executor.getIdResolver();
        EList eParameters = this.eOperation.getEParameters();
        Object[] ecoreValues = new Object[boxedArgumentValues.length];
        int iMax = Math.min(boxedArgumentValues.length, eParameters.size());
        int i = 0;
        while (i < iMax) {
            Object argumentValue = boxedArgumentValues[i];
            EParameter eParameter = (EParameter)eParameters.get(i);
            ecoreValues[i] = idResolver.ecoreValueOf(eParameter.getEType().getInstanceClass(), argumentValue);
            ++i;
        }
        EcoreEList.UnmodifiableEList ecoreArguments = new EcoreEList.UnmodifiableEList(null, null, iMax, ecoreValues);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, (EList)ecoreArguments);
            return this.getResultValue(executor, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue(e);
        }
    }

    @Deprecated
    protected @Nullable Object getResultValue(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object eResult) {
        return this.evaluate(EInvokeOperation.getExecutor(evaluator), returnTypeId, eResult, new Object[0]);
    }

    protected @Nullable Object getResultValue(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object eResult) {
        if (returnTypeId instanceof CollectionTypeId) {
            if (eResult instanceof Iterable) {
                return executor.getIdResolver().createCollectionOfAll((CollectionTypeId)returnTypeId, (Iterable)eResult);
            }
            throw new InvalidValueException("Non-iterable result", new Object[0]);
        }
        if (eResult != null) {
            @NonNull EClassifier eType = this.eOperation.getEType();
            return executor.getIdResolver().boxedValueOf(eResult, eType);
        }
        return null;
    }
}

