/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.CompleteClassImpl;
import org.eclipse.ocl.pivot.internal.CompletePackageImpl;
import org.eclipse.ocl.pivot.internal.OrphanCompletePackageImpl;
import org.eclipse.ocl.pivot.internal.PrimitiveCompletePackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.values.CollectionTypeParameters;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapTypeParameters;

public class CompleteClasses
extends EObjectContainmentWithInverseEList<CompleteClass> {
    private static final Logger logger = Logger.getLogger(CompleteClasses.class);
    public static final @NonNull TracingOption COMPLETE_CLASSES = new TracingOption("org.eclipse.ocl.pivot", "completeClasses");
    private static final long serialVersionUID = 1L;
    protected @Nullable Map<String, CompleteClassInternal> name2completeClass = null;

    public CompleteClasses(@NonNull CompletePackageImpl owner) {
        super(CompleteClass.class, (InternalEObject)owner, PivotPackage.Literals.COMPLETE_PACKAGE__OWNED_COMPLETE_CLASSES.getFeatureID(), PivotPackage.Literals.COMPLETE_CLASS__OWNING_COMPLETE_PACKAGE.getFeatureID());
        if (COMPLETE_CLASSES.isActive()) {
            COMPLETE_CLASSES.println("Create " + (Object)((Object)this));
        }
    }

    protected void didAdd(int index, CompleteClass completeClass) {
        assert (completeClass != null);
        super.didAdd(index, (Object)completeClass);
        this.didAdd((CompleteClassInternal)completeClass);
    }

    public void didAdd(@NonNull CompleteClassInternal completeClass) {
        String name;
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        if (name2completeClass2 != null && (name = completeClass.getName()) != null) {
            CompleteClass oldCompleteClass = name2completeClass2.put(name, completeClass);
            assert (oldCompleteClass == null);
        }
    }

    public void didAddClass(@NonNull Class partialClass) {
        if (this.name2completeClass != null) {
            CompleteClassInternal completeClass = this.name2completeClass.get(partialClass.getName());
            if (completeClass == null) {
                this.doRefreshPartialClass(partialClass);
            } else {
                completeClass.addClass(partialClass);
            }
        }
    }

    public void didAddPackage(@NonNull Package partialPackage) {
        if (this.name2completeClass != null) {
            this.doRefreshPartialClasses(partialPackage);
        }
    }

    protected void didRemove(int index, CompleteClass completeClass) {
        assert (completeClass != null);
        this.didRemove(completeClass);
        super.didRemove(index, (Object)completeClass);
    }

    protected void didRemove(@NonNull CompleteClass completeClass) {
        String name;
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        if (name2completeClass2 != null && (name = completeClass.getName()) != null) {
            CompleteClassInternal oldCompleteClass = name2completeClass2.remove(name);
            assert (oldCompleteClass == completeClass);
        }
    }

    public void didRemoveClass(@NonNull Class partialClass) {
        CompleteClassInternal completeClass;
        if (this.name2completeClass != null && (completeClass = this.name2completeClass.get(partialClass.getName())) != null && completeClass.didRemoveClass(partialClass)) {
            this.remove(completeClass);
            completeClass.dispose();
        }
        if (partialClass.getUnspecializedElement() == null) {
            this.getCompleteModel().didRemoveClass(partialClass);
        }
    }

    public void didRemovePackage(@NonNull Package partialPackage) {
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        if (name2completeClass2 != null) {
            for (Class partialClass : partialPackage.getOwnedClasses()) {
                if (partialClass == null) continue;
                this.didRemoveClass(partialClass);
            }
        }
    }

    protected void doRefreshPartialClass(@NonNull Class partialClass) {
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        assert (name2completeClass2 != null);
        CompleteModelInternal completeModel = this.getCompleteModel();
        String name = partialClass.getName();
        if (name != null) {
            CompleteClassInternal completeClass = null;
            if (partialClass instanceof PrimitiveType) {
                PrimitiveCompletePackageImpl primitiveCompletePackage = completeModel.getPrimitiveCompletePackage();
                completeClass = primitiveCompletePackage.getCompleteClass(partialClass);
            } else if (partialClass instanceof MapType && partialClass.getUnspecializedElement() != null) {
                OrphanCompletePackageImpl orphanCompletePackage = completeModel.getOrphanCompletePackage();
                completeClass = orphanCompletePackage.getCompleteClass(partialClass);
            } else if ("$metamodel$".equals(this.getCompletePackage().getURI())) {
                PrimitiveCompletePackageImpl primitiveCompletePackage = completeModel.getPrimitiveCompletePackage();
                completeClass = primitiveCompletePackage.getOwnedCompleteClass(name);
            }
            if (completeClass == null && (completeClass = name2completeClass2.get(name)) == null) {
                completeClass = partialClass.getOwnedSignature() == null ? (CompleteClassInternal)PivotFactory.eINSTANCE.createCompleteClass() : (partialClass instanceof CollectionType ? new CollectionCompleteClassImpl() : (partialClass instanceof MapType ? new MapCompleteClassImpl() : (CompleteClassInternal)PivotFactory.eINSTANCE.createCompleteClass()));
                completeClass.setName(name);
                this.add(completeClass);
            }
            completeClass.addClass(partialClass);
        }
    }

    protected @NonNull Map<String, CompleteClassInternal> doRefreshPartialClasses() {
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        if (name2completeClass2 == null) {
            name2completeClass2 = this.name2completeClass = new HashMap<String, CompleteClassInternal>();
        }
        Iterator iterator = this.getCompletePackage().getPartialPackages().iterator();
        while (iterator.hasNext()) {
            Package partialPackage = (Package)iterator.next();
            if (partialPackage == null) continue;
            this.doRefreshPartialClasses(partialPackage);
        }
        return name2completeClass2;
    }

    protected void doRefreshPartialClasses(@NonNull Package partialPackage) {
        for (Class partialClass : partialPackage.getOwnedClasses()) {
            if (partialClass == null) continue;
            this.doRefreshPartialClass(partialClass);
        }
    }

    public @NonNull CompleteModelInternal getCompleteModel() {
        return this.getCompletePackage().getCompleteModel();
    }

    public @NonNull CompletePackageInternal getCompletePackage() {
        return (CompletePackageInternal)this.owner;
    }

    public @Nullable CompleteClassInternal getOwnedCompleteClass(String name) {
        Map<String, CompleteClassInternal> name2completeClass2 = this.name2completeClass;
        if (name2completeClass2 == null) {
            name2completeClass2 = this.doRefreshPartialClasses();
        }
        return name2completeClass2.get(name);
    }

    public @NonNull Iterator<CompleteClass> iterator() {
        if (this.name2completeClass == null) {
            this.doRefreshPartialClasses();
        }
        return super.iterator();
    }

    public @NonNull ListIterator<CompleteClass> listIterator() {
        if (this.name2completeClass == null) {
            this.doRefreshPartialClasses();
        }
        return super.listIterator();
    }

    public @NonNull ListIterator<CompleteClass> listIterator(int index) {
        if (this.name2completeClass == null) {
            this.doRefreshPartialClasses();
        }
        return super.listIterator(index);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + this.owner.toString();
    }

    protected static class CollectionCompleteClassImpl
    extends CompleteClassImpl {
        private @Nullable Map<@NonNull CollectionTypeParameters<@NonNull Type>, @NonNull WeakReference<@NonNull CollectionType>> collections = null;

        protected CollectionCompleteClassImpl() {
        }

        protected @NonNull CollectionType createSpecialization(@NonNull CollectionTypeParameters<@NonNull Type> typeParameters) {
            Class unspecializedType = this.getPrimaryClass();
            String typeName = unspecializedType.getName();
            TemplateSignature templateSignature = unspecializedType.getOwnedSignature();
            List<@NonNull TemplateParameter> templateParameters = ClassUtil.nullFree(templateSignature.getOwnedParameters());
            EClass eClass = unspecializedType.eClass();
            EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
            CollectionType specializedType = (CollectionType)eFactoryInstance.create(eClass);
            specializedType.setName(typeName);
            TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
            TemplateParameter formalParameter = ClassUtil.nonNull(templateParameters.get(0));
            assert (formalParameter != null);
            Type elementType = typeParameters.getElementType();
            TemplateParameterSubstitution templateParameterSubstitution = CompleteInheritanceImpl.createTemplateParameterSubstitution(formalParameter, elementType);
            templateBinding.getOwnedSubstitutions().add(templateParameterSubstitution);
            specializedType.getOwnedBindings().add(templateBinding);
            this.getCompleteModel().resolveSuperClasses(specializedType, unspecializedType);
            CollectionType specializedCollectionType = specializedType;
            specializedCollectionType.setIsNullFree(typeParameters.isNullFree());
            try {
                specializedCollectionType.setLowerValue(typeParameters.getLower());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Out of range lower bound", (Throwable)e);
            }
            try {
                specializedCollectionType.setUpperValue(typeParameters.getUpper());
            }
            catch (InvalidValueException e) {
                logger.error((Object)"Out of range upper bound", (Throwable)e);
            }
            specializedType.setUnspecializedElement(unspecializedType);
            PivotMetamodelManager metamodelManager = this.getCompleteModel().getMetamodelManager();
            Orphanage orphanage = Orphanage.getOrphanage(metamodelManager.getASResourceSet());
            specializedType.setOwningPackage(orphanage);
            return specializedType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized @Nullable CollectionType findCollectionType(@NonNull CollectionTypeParameters<@NonNull Type> typeParameters) {
            TemplateSignature templateSignature = this.getPrimaryClass().getOwnedSignature();
            List<@NonNull TemplateParameter> templateParameters = ClassUtil.nullFree(templateSignature.getOwnedParameters());
            if (templateParameters.size() != 1) {
                return null;
            }
            Map<CollectionTypeParameters<Type>, WeakReference<CollectionType>> specializations2 = this.collections;
            if (specializations2 == null) {
                return null;
            }
            WeakReference<CollectionType> weakReference = specializations2.get(typeParameters);
            if (weakReference == null) {
                return null;
            }
            CollectionType type = (CollectionType)weakReference.get();
            if (type == null) {
                Map<CollectionTypeParameters<Type>, WeakReference<CollectionType>> map = specializations2;
                synchronized (map) {
                    type = (CollectionType)weakReference.get();
                    if (type == null) {
                        specializations2.remove(typeParameters);
                    }
                }
            }
            return type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized @NonNull CollectionType getCollectionType(@NonNull CollectionTypeParameters<@NonNull Type> typeParameters) {
            Object object;
            Map<@NonNull CollectionTypeParameters<@NonNull Type>, @NonNull WeakReference<@NonNull CollectionType>> specializations2 = this.collections;
            if (specializations2 == null) {
                object = this;
                synchronized (object) {
                    specializations2 = this.collections;
                    if (specializations2 == null) {
                        specializations2 = this.collections = new HashMap<CollectionTypeParameters<Type>, WeakReference<CollectionType>>();
                    }
                }
            }
            object = specializations2;
            synchronized (object) {
                CollectionType specializedType = null;
                WeakReference<@NonNull CollectionType> weakReference = specializations2.get(typeParameters);
                if (weakReference != null) {
                    specializedType = (CollectionType)weakReference.get();
                }
                if (specializedType == null) {
                    specializedType = this.createSpecialization(typeParameters);
                    specializations2.put(typeParameters, new WeakReference<CollectionType>(specializedType));
                }
                return specializedType;
            }
        }
    }

    protected static class MapCompleteClassImpl
    extends CompleteClassImpl {
        private @Nullable Map<@NonNull MapTypeParameters<@NonNull Type, @NonNull Type>, @NonNull WeakReference<@NonNull MapType>> maps = null;

        protected MapCompleteClassImpl() {
        }

        protected @NonNull MapType createSpecialization(@NonNull MapTypeParameters<@NonNull Type, @NonNull Type> typeParameters) {
            Class unspecializedType = this.getPrimaryClass();
            String typeName = unspecializedType.getName();
            TemplateSignature templateSignature = unspecializedType.getOwnedSignature();
            List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
            EClass eClass = unspecializedType.eClass();
            EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
            MapType specializedMapType = (MapType)eFactoryInstance.create(eClass);
            specializedMapType.setName(typeName);
            TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
            TemplateParameter keyFormalParameter = templateParameters.get(0);
            TemplateParameter valueFormalParameter = templateParameters.get(1);
            assert (keyFormalParameter != null);
            assert (valueFormalParameter != null);
            Type keyType = typeParameters.getKeyType();
            Type valueType = typeParameters.getValueType();
            TemplateParameterSubstitution keyTemplateParameterSubstitution = CompleteInheritanceImpl.createTemplateParameterSubstitution(keyFormalParameter, keyType);
            TemplateParameterSubstitution valueTemplateParameterSubstitution = CompleteInheritanceImpl.createTemplateParameterSubstitution(valueFormalParameter, valueType);
            templateBinding.getOwnedSubstitutions().add(keyTemplateParameterSubstitution);
            templateBinding.getOwnedSubstitutions().add(valueTemplateParameterSubstitution);
            specializedMapType.getOwnedBindings().add(templateBinding);
            this.getCompleteModel().resolveSuperClasses(specializedMapType, unspecializedType);
            specializedMapType.setKeysAreNullFree(typeParameters.isKeysAreNullFree());
            specializedMapType.setValuesAreNullFree(typeParameters.isValuesAreNullFree());
            specializedMapType.setUnspecializedElement(unspecializedType);
            PivotMetamodelManager metamodelManager = this.getCompleteModel().getMetamodelManager();
            Orphanage orphanage = Orphanage.getOrphanage(metamodelManager.getASResourceSet());
            specializedMapType.setOwningPackage(orphanage);
            specializedMapType.setEntryClass(typeParameters.getEntryClass());
            return specializedMapType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized @Nullable MapType findMapType(@NonNull MapTypeParameters<@NonNull Type, @NonNull Type> typeParameters) {
            TemplateSignature templateSignature = this.getPrimaryClass().getOwnedSignature();
            List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
            if (templateParameters.size() != 1) {
                return null;
            }
            Map<@NonNull MapTypeParameters<@NonNull Type, @NonNull Type>, @NonNull WeakReference<@NonNull MapType>> specializations2 = this.maps;
            if (specializations2 == null) {
                return null;
            }
            WeakReference<MapType> weakReference = specializations2.get(typeParameters);
            if (weakReference == null) {
                return null;
            }
            MapType type = (MapType)weakReference.get();
            if (type == null) {
                Map<MapTypeParameters<Type, Type>, WeakReference<MapType>> map = specializations2;
                synchronized (map) {
                    type = (MapType)weakReference.get();
                    if (type == null) {
                        specializations2.remove(typeParameters);
                    }
                }
            }
            return type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized @NonNull MapType getMapType(@NonNull MapTypeParameters<@NonNull Type, @NonNull Type> typeParameters) {
            Object object;
            Map<@NonNull MapTypeParameters<@NonNull Type, @NonNull Type>, @NonNull WeakReference<@NonNull MapType>> specializations2 = this.maps;
            if (specializations2 == null) {
                object = this;
                synchronized (object) {
                    specializations2 = this.maps;
                    if (specializations2 == null) {
                        specializations2 = this.maps = new HashMap<MapTypeParameters<Type, Type>, WeakReference<MapType>>();
                    }
                }
            }
            object = specializations2;
            synchronized (object) {
                MapType specializedType = null;
                WeakReference<@NonNull MapType> weakReference = specializations2.get(typeParameters);
                if (weakReference != null) {
                    specializedType = (MapType)weakReference.get();
                }
                if (specializedType == null) {
                    specializedType = this.createSpecialization(typeParameters);
                    specializations2.put(typeParameters, new WeakReference<MapType>(specializedType));
                }
                return specializedType;
            }
        }
    }
}

