/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;

public class PapyrusTableSizeCalculation {
    public static int getRowHeaderWidth(AbstractNattableWidgetManager nattableModelManager) {
        int headerWidth = 0;
        if (nattableModelManager.getRowHeaderLayerStack() != null) {
            int headerColumnIndex = 0;
            while (headerColumnIndex < nattableModelManager.getRowHeaderLayerStack().getColumnCount()) {
                headerWidth += nattableModelManager.getRowHeaderLayerStack().getColumnWidthByPosition(headerColumnIndex);
                ++headerColumnIndex;
            }
        }
        return headerWidth;
    }

    public static int getColumnFillWidth(AbstractNattableWidgetManager nattableWidgetManager, int parentSize) {
        int columnSize = 0;
        if (parentSize > 0) {
            int headerWidth = PapyrusTableSizeCalculation.getRowHeaderWidth(nattableWidgetManager);
            int allColumnsSize = parentSize - headerWidth;
            columnSize = allColumnsSize / nattableWidgetManager.getBodyLayerStack().getColumnHideShowLayer().getColumnCount();
        }
        return columnSize;
    }
}

