/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NattableMergePropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        HashMap<String, Boolean> mergeMap = new HashMap<String, Boolean>();
        INattableModelManager manager = this.getNattableModelManager();
        if (manager == null) {
            return false;
        }
        AbstractHeaderAxisConfiguration rowHeader = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(manager.getTable());
        AbstractHeaderAxisConfiguration columnHeader = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(manager.getTable());
        BooleanValueStyle rowsMerge = (BooleanValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeRows");
        BooleanValueStyle columnsMerge = (BooleanValueStyle)columnHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeColumns");
        boolean selectedRowsMerge = this.getToMergeRowBoolean();
        boolean selectedColumnsMerge = this.getToMergeColumnBoolean();
        if (rowsMerge != null) {
            mergeMap.put("mergeRows", rowsMerge.isBooleanValue());
        } else {
            mergeMap.put("mergeRows", false);
        }
        if (columnsMerge != null) {
            mergeMap.put("mergeColumns", columnsMerge.isBooleanValue());
        } else {
            mergeMap.put("mergeColumns", false);
        }
        if (selectedRowsMerge) {
            mergeMap.put("mergeSelectedRows", selectedRowsMerge);
        } else {
            mergeMap.put("mergeSelectedRows", false);
        }
        if (selectedColumnsMerge) {
            mergeMap.put("mergeSelectedColumns", selectedColumnsMerge);
        } else {
            mergeMap.put("mergeSelectedColumns", false);
        }
        if (this.getNattableModelManager() != null && expectedValue instanceof Boolean) {
            if ("mergeRows".equals(property)) {
                if (!this.tableMerged(mergeMap)) {
                    return true;
                }
                return mergeMap.get("mergeRows");
            }
            if ("mergeColumns".equals(property)) {
                if (!this.tableMerged(mergeMap)) {
                    return true;
                }
                return mergeMap.get("mergeColumns");
            }
            if ("mergeSelectedRows".equals(property)) {
                if (!this.tableMerged(mergeMap)) {
                    return true;
                }
                return mergeMap.get("mergeSelectedRows");
            }
            if ("mergeSelectedColumns".equals(property)) {
                if (!this.tableMerged(mergeMap)) {
                    return true;
                }
                return mergeMap.get("mergeSelectedColumns");
            }
        }
        return false;
    }

    protected INattableModelManager getNattableModelManager() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbench;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPart current = null;
        if (workbench != null && (activeWorkbench = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbench.getActivePage()) != null) {
            current = activePage.getActivePart();
        }
        if (current != null) {
            return (INattableModelManager)current.getAdapter(INattableModelManager.class);
        }
        return null;
    }

    protected boolean tableMerged(HashMap<String, Boolean> mergeMap) {
        return mergeMap.get("mergeRows") != false || mergeMap.get("mergeColumns") != false || mergeMap.get("mergeSelectedRows") != false || mergeMap.get("mergeSelectedColumns") != false;
    }

    protected boolean getToMergeRowBoolean() {
        for (Object currentObject : this.getNattableModelManager().getRowElementsList()) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            if (!(currentObject instanceof IAxis) || (axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows")) == null || !axisToMerge.isBooleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean getToMergeColumnBoolean() {
        for (Object currentObject : this.getNattableModelManager().getColumnElementsList()) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            if (!(currentObject instanceof IAxis) || (axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns")) == null || !axisToMerge.isBooleanValue()) continue;
            return true;
        }
        return false;
    }
}

