/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;

public class MarkerInfo {
    private final int start;
    private final int end;
    private final MessagerImpl.Severity severity;
    private final String msg;
    private final int line;

    public MarkerInfo(int start, int end, MessagerImpl.Severity severity, String msg, int line) {
        this.start = start;
        this.end = end;
        this.severity = severity;
        this.msg = msg;
        this.line = line;
    }

    private int getSeverity() {
        switch (this.severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new IllegalStateException("Unhandled severity level: " + (Object)((Object)this.severity));
    }

    public boolean isError() {
        return this.severity == MessagerImpl.Severity.ERROR;
    }

    public void copyIntoMarker(IMarker marker) throws CoreException {
        marker.setAttribute("charStart", this.start);
        marker.setAttribute("charEnd", this.end);
        marker.setAttribute("severity", this.getSeverity());
        marker.setAttribute("message", (Object)this.msg);
        marker.setAttribute("lineNumber", this.line);
    }
}

