/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.build;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.eclipse.jdt.apt.core.internal.build.Messages;

public class JdtApt
extends Java {
    private static final String APP_CLASSNAME = "org.eclipse.core.launcher.Main";
    private static final String APP_PLUGIN = "org.eclipse.jdt.apt.core.aptBuild";
    private File workspace;
    private File startupJar;

    public void setWorkspace(File file) {
        if (!file.exists()) {
            throw new BuildException(String.valueOf(Messages.JdtApt_noWorkspace) + file);
        }
        this.workspace = file;
    }

    public void setEclipseHome(File file) {
        if (!file.exists()) {
            throw new BuildException(String.valueOf(Messages.JdtApt_noEclipse) + file);
        }
        this.startupJar = new File(file, "startup.jar");
        if (!this.startupJar.exists()) {
            throw new BuildException(String.valueOf(Messages.JdtApt_noStartupJar) + file);
        }
    }

    public void execute() throws BuildException {
        if (this.workspace == null) {
            throw new BuildException("Must set a workspace");
        }
        if (this.startupJar == null) {
            throw new BuildException("Must set eclipse home");
        }
        this.setFork(true);
        this.setLogError(true);
        this.setClasspath(new Path(null, this.startupJar.getAbsolutePath()));
        this.setClassname(APP_CLASSNAME);
        this.createArg().setValue("-noupdate");
        this.createArg().setValue("-application");
        this.createArg().setValue(APP_PLUGIN);
        this.createArg().setValue("-data");
        this.createArg().setValue(this.workspace.getAbsolutePath());
        super.execute();
    }
}

