/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.properties.Messages;
import org.eclipse.mylyn.internal.team.ui.properties.TeamPropertiesLinkProvider;
import org.eclipse.mylyn.internal.team.ui.templates.TemplateHandlerContentProposalProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ProjectTeamPage
extends PropertyPage {
    private IProject project;
    private boolean modified;
    private boolean ignoreModifyEvents;
    private Button useProjectSettings;
    private Text commitTemplateText;
    private Composite propertiesComposite;
    private Hyperlink configurationHyperlink;
    private Label label;

    public ProjectTeamPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.createDescription(composite);
        this.createPropertiesControl(composite);
        this.initialize();
        return composite;
    }

    private void createDescription(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useProjectSettings = new Button(composite, 32);
        this.useProjectSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProjectTeamPage.this.ignoreModifyEvents) {
                    ProjectTeamPage.this.modified = true;
                }
                ProjectTeamPage.this.setPropertiesEnabled(ProjectTeamPage.this.useProjectSettings.getSelection());
            }
        });
        this.useProjectSettings.setText(Messages.ProjectTeamPage_Enable_project_specific_settings);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.useProjectSettings);
        this.configurationHyperlink = new Hyperlink(composite, 0);
        this.configurationHyperlink.setUnderlined(true);
        this.configurationHyperlink.setText(Messages.ProjectTeamPage_Configure_workspace);
        this.configurationHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)ProjectTeamPage.this.getShell(), (String)"org.eclipse.mylyn.team.ui.ui.preferences", (String[])new String[]{"org.eclipse.mylyn.team.ui.ui.preferences"}, null);
                dlg.open();
            }
        });
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(composite.getFont());
    }

    private void setPropertiesEnabled(boolean enabled) {
        this.propertiesComposite.setEnabled(enabled);
        Control[] controlArray = this.propertiesComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
        this.commitTemplateText.setEnabled(enabled);
        this.configurationHyperlink.setEnabled(!enabled);
        if (!enabled) {
            this.configurationHyperlink.setForeground(JFaceColors.getHyperlinkText((Display)this.getShell().getDisplay()));
        } else {
            this.configurationHyperlink.setForeground(this.getShell().getDisplay().getSystemColor(33));
        }
    }

    private void createPropertiesControl(Composite parent) {
        this.propertiesComposite = new Composite(parent, 0);
        this.propertiesComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.propertiesComposite.setLayout((Layout)layout);
        this.propertiesComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.label = new Label(this.propertiesComposite, 0);
        this.label.setText(Messages.ProjectTeamPage_Commit_Comment_Template);
        String completedTemplate = "";
        this.commitTemplateText = this.addTemplateField(this.propertiesComposite, completedTemplate, new TemplateHandlerContentProposalProvider());
    }

    private Text addTemplateField(Composite parent, String text, IContentProposalProvider provider) {
        TextContentAdapter adapter = new TextContentAdapter();
        Text control = new Text(parent, 2562);
        control.setText(text);
        control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ProjectTeamPage.this.ignoreModifyEvents) {
                    ProjectTeamPage.this.modified = true;
                }
            }
        });
        new ContentAssistCommandAdapter((Control)control, (IControlContentAdapter)adapter, provider, null, new char[]{'$'}, true);
        GridData gd = new GridData();
        gd.heightHint = 60;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.grabExcessVerticalSpace = false;
        control.setLayoutData((Object)gd);
        return control;
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        try {
            this.ignoreModifyEvents = true;
            TeamPropertiesLinkProvider provider = new TeamPropertiesLinkProvider();
            String template = provider.getCommitCommentTemplate((IResource)this.project);
            if (template == null) {
                this.useProjectSettings.setSelection(false);
                this.setPropertiesEnabled(false);
                this.commitTemplateText.setText(FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template"));
            } else {
                this.useProjectSettings.setSelection(true);
                this.setPropertiesEnabled(true);
                this.commitTemplateText.setText(template);
            }
        }
        finally {
            this.ignoreModifyEvents = false;
        }
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        TeamPropertiesLinkProvider provider = new TeamPropertiesLinkProvider();
        if (this.useProjectSettings.getSelection()) {
            provider.setCommitCommentTemplate((IResource)this.project, this.commitTemplateText.getText());
        } else {
            provider.setCommitCommentTemplate((IResource)this.project, null);
        }
        return true;
    }
}

