/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;

public class ActionBarsHelper {
    private final IActionBars bars;
    private final Map<String, IAction> globalActions = new HashMap<String, IAction>();
    private final Map<String, IAction> previousActions = new HashMap<String, IAction>();

    public ActionBarsHelper(IActionBars actionBars) {
        this.bars = actionBars;
    }

    public ActionBarsHelper addGlobalAction(String actionID, IAction action) {
        this.globalActions.put(actionID, action);
        return this;
    }

    public ActionBarsHelper install(Viewer viewer) {
        return this.install(viewer.getControl(), (ISelectionProvider)viewer);
    }

    public ActionBarsHelper install(Control control) {
        return this.install(control, null);
    }

    private ActionBarsHelper install(Control control, final ISelectionProvider selectionProvider) {
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ActionBarsHelper.this.unsetGlobalActions();
                ActionBarsHelper.this.bars.updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                this.updateActions();
                ActionBarsHelper.this.setGlobalActions();
                ActionBarsHelper.this.bars.updateActionBars();
            }

            private void updateActions() {
                if (selectionProvider != null) {
                    SelectionChangedEvent selectionEvent = null;
                    for (IAction next : ActionBarsHelper.this.globalActions.values()) {
                        if (!(next instanceof ISelectionChangedListener)) continue;
                        if (selectionEvent == null) {
                            selectionEvent = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
                        }
                        ((ISelectionChangedListener)next).selectionChanged(selectionEvent);
                    }
                }
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ActionBarsHelper.this.globalActions.clear();
                ActionBarsHelper.this.previousActions.clear();
            }
        });
        return this;
    }

    protected void setGlobalActions() {
        this.previousActions.clear();
        for (Map.Entry<String, IAction> next : this.globalActions.entrySet()) {
            this.previousActions.put(next.getKey(), this.bars.getGlobalActionHandler(next.getKey()));
            this.bars.setGlobalActionHandler(next.getKey(), next.getValue());
        }
    }

    protected void unsetGlobalActions() {
        for (Map.Entry<String, IAction> next : this.previousActions.entrySet()) {
            this.bars.setGlobalActionHandler(next.getKey(), next.getValue());
        }
        this.previousActions.clear();
    }
}

