/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.swt.graphics.Image;

public class BugzillaImages {
    private static ImageRegistry imageRegistry;
    private static final URL baseURL;
    public static final String T_ELCL = "elcl16";
    public static final String T_TOOL = "etool16";
    public static final String T_VIEW = "eview16";
    public static final ImageDescriptor OVERLAY_BUGZILLA;
    public static final ImageDescriptor BUG;
    public static final ImageDescriptor GERRIT;
    public static final ImageDescriptor GIT;
    public static final ImageDescriptor BUG_COMMENT;
    public static final ImageDescriptor REMOVE_ALL;
    public static final ImageDescriptor REMOVE;
    public static final ImageDescriptor SELECT_ALL;
    public static final ImageDescriptor OPEN;
    public static final ImageDescriptor OVERLAY_CRITICAL;
    public static final ImageDescriptor OVERLAY_MAJOR;
    public static final ImageDescriptor OVERLAY_ENHANCEMENT;
    public static final ImageDescriptor OVERLAY_TRIVIAL;

    static {
        baseURL = BugzillaUiPlugin.getDefault().getBundle().getEntry("/icons/");
        OVERLAY_BUGZILLA = BugzillaImages.create(T_VIEW, "overlay-bugzilla.gif");
        BUG = BugzillaImages.create(T_ELCL, "bug.gif");
        GERRIT = BugzillaImages.create(T_ELCL, "gerrit.gif");
        GIT = BugzillaImages.create(T_ELCL, "git.png");
        BUG_COMMENT = BugzillaImages.create(T_ELCL, "bug-comment.gif");
        REMOVE_ALL = BugzillaImages.create("", "remove-all.gif");
        REMOVE = BugzillaImages.create("", "remove.gif");
        SELECT_ALL = BugzillaImages.create("", "selectAll.gif");
        OPEN = BugzillaImages.create("", "openresult.gif");
        OVERLAY_CRITICAL = BugzillaImages.create(T_VIEW, "overlay-critical.gif");
        OVERLAY_MAJOR = BugzillaImages.create(T_VIEW, "overlay-major.gif");
        OVERLAY_ENHANCEMENT = BugzillaImages.create(T_VIEW, "overlay-enhancement.gif");
        OVERLAY_TRIVIAL = BugzillaImages.create(T_VIEW, "overlay-trivial.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BugzillaImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = BugzillaImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

