/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.actions;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.views.validation.internal.actions.AbstractMarkerAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyMarkerAction
extends AbstractMarkerAction {
    public CopyMarkerAction(IWorkbenchSite site) {
        super(site, "Copy");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setActionDefinitionId(ActionFactory.COPY.getCommandId());
    }

    public void run() {
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        if (selectionProvider instanceof TableViewer) {
            TableViewer viewer = (TableViewer)selectionProvider;
            String text = this.copy(viewer);
            Clipboard clipboard = new Clipboard(viewer.getControl().getDisplay());
            try {
                clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private String copy(TableViewer viewer) {
        String recordSep = System.getProperty("line.separator");
        String fieldSep = "\t";
        StringBuilder result = new StringBuilder();
        result.append("Severity").append("\t");
        result.append("Description").append("\t");
        result.append("Element").append("\t");
        result.append("Parent").append("\t");
        result.append("Type").append(recordSep);
        boolean startIndex = true;
        int columnCount = viewer.getTable().getColumnCount();
        CellLabelProvider[] labelProviders = new CellLabelProvider[columnCount - 1];
        int i = 1;
        while (i < columnCount) {
            labelProviders[i - 1] = viewer.getLabelProvider(i);
            ++i;
        }
        for (IPapyrusMarker next : this.getMarkers()) {
            result.append(CopyMarkerAction.getSeverity(next));
            int i2 = 0;
            while (i2 < labelProviders.length) {
                result.append("\t");
                result.append(labelProviders[i2].getToolTipText((Object)next));
                ++i2;
            }
            result.append(recordSep);
        }
        return result.toString();
    }

    private static String getSeverity(IPapyrusMarker marker) {
        String result;
        switch (marker.getAttribute("severity", 2)) {
            case 0: {
                result = "Info";
                break;
            }
            case 1: {
                result = "Warning";
                break;
            }
            default: {
                result = "Error";
            }
        }
        return result;
    }
}

