/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.commons.core.ErrorReporterManager;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.log.LogEntry;
import org.eclipse.ui.internal.views.log.LogSession;

public class NewTaskFromErrorAction
implements IObjectActionDelegate {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private LogEntry entry;

    private void createTask(LogEntry entry) {
        ErrorLogStatus status = this.createStatus(entry);
        new ErrorReporterManager().fail((IStatus)status);
    }

    private ErrorLogStatus createStatus(LogEntry entry) {
        ErrorLogStatus status = new ErrorLogStatus(entry.getSeverity(), entry.getPluginId(), entry.getCode(), entry.getMessage());
        try {
            Object[] children;
            status.setDate(entry.getDate());
            status.setStack(entry.getStack());
            LogSession session = entry.getSession();
            if (session != null) {
                status.setLogSessionData(session.getSessionData());
            }
            if (entry.hasChildren() && (children = entry.getChildren((Object)entry)) != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof LogEntry) {
                        ErrorLogStatus childStatus = this.createStatus((LogEntry)child);
                        status.add((IStatus)childStatus);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public void run() {
        this.createTask(this.entry);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof LogEntry) {
            this.entry = (LogEntry)object;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

