/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSSWTCursorHelper {
    private static final String DEFAULT_CURSOR = "defaultCursor";

    public static Cursor getSWTCursor(CSSValue value, Display display) {
        if (value.getCssValueType() != 1) {
            return null;
        }
        int i = CSSSWTCursorHelper.getSWTCursorId((CSSPrimitiveValue)value);
        if (i == 0) {
            return null;
        }
        return new Cursor((Device)display, i);
    }

    public static String getCSSCursor(Cursor cursor) {
        if (cursor == null) {
            return "auto";
        }
        return "auto";
    }

    public static int getSWTCursorId(CSSPrimitiveValue value) {
        String cursorName;
        switch (cursorName = value.getStringValue()) {
            case "default": {
                return 0;
            }
            case "auto": {
                return 0;
            }
            case "crosshair": {
                return 2;
            }
            case "pointer": {
                return 21;
            }
            case "move": {
                return 18;
            }
            case "e-resize": {
                return 12;
            }
            case "ne-resize": {
                return 14;
            }
            case "nw-resize": {
                return 17;
            }
            case "n-resize": {
                return 10;
            }
            case "se-resize": {
                return 15;
            }
            case "sw-resize": {
                return 16;
            }
            case "s-resize": {
                return 11;
            }
            case "w-resize": {
                return 13;
            }
            case "text": {
                return 18;
            }
            case "wait": {
                return 1;
            }
            case "help": {
                return 4;
            }
        }
        return 0;
    }

    public static void storeDefaultCursor(Control control) {
        if (control.getData(DEFAULT_CURSOR) == null) {
            control.setData(DEFAULT_CURSOR, (Object)control.getCursor());
        }
    }

    public static void restoreDefaultCursor(Control control) {
        Cursor defaultCursor = (Cursor)control.getData(DEFAULT_CURSOR);
        if (defaultCursor != null) {
            control.setCursor(defaultCursor.isDisposed() ? control.getDisplay().getSystemCursor(4) : defaultCursor);
        }
    }
}

