/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.services.editpart;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpart.EditPartProviderConfiguration;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpart.IEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateRootEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.View;

public final class EditPartService
extends Service
implements IEditPartProvider,
EditPartFactory {
    private static final EditPartService instance = new EditPartService();

    private EditPartService() {
        super(true, false);
        this.configureProviders(DiagramUIPlugin.getPluginId(), "editpartProviders");
    }

    public static EditPartService getInstance() {
        return instance;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected Map createPriorityCache() {
        return new HashMap();
    }

    protected Object getCachingKey(IOperation operation) {
        return ((IEditPartOperation)operation).getCachingKey();
    }

    @Override
    public IGraphicalEditPart createGraphicEditPart(View view) {
        if (view == null) {
            return null;
        }
        IGraphicalEditPart result = null;
        CreateGraphicEditPartOperation createGraphicEditPartOperation = new CreateGraphicEditPartOperation(view);
        result = (IGraphicalEditPart)this.execute(createGraphicEditPartOperation);
        if (result == null) {
            if (view instanceof Node) {
                result = ((Node)view).getLayoutConstraint() instanceof Ratio ? new DefaultCompartmentEditPart(view) : new DefaultNodeEditPart(view);
            } else if (view instanceof Edge) {
                result = new DefaultConnectionEditPart(view);
            } else if (view instanceof Diagram) {
                result = new DiagramEditPart(view);
            }
        }
        return result;
    }

    private Object execute(IOperation operation) {
        List results = this.execute(ExecutionStrategy.FIRST, operation);
        return results.isEmpty() ? null : results.get(0);
    }

    public EditPart createEditPart(EditPart context, final Object model) {
        try {
            return (EditPart)TransactionUtil.getEditingDomain((Object)model).runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(EditPartService.this.createGraphicEditPart((View)model));
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"createEditPart", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"createEditPart", (Throwable)e);
            return null;
        }
    }

    @Override
    public RootEditPart createRootEditPart(Diagram diagram) {
        CreateRootEditPartOperation createRootEditPartOperation = new CreateRootEditPartOperation(diagram);
        RootEditPart result = (RootEditPart)this.execute(createRootEditPartOperation);
        return result == null ? new DiagramRootEditPart(diagram.getMeasurementUnit()) : result;
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private EditPartProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = EditPartProviderConfiguration.parse(element);
            Assert.isNotNull((Object)((Object)this.providerConfiguration));
        }

        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (this.provider == null) {
                if (this.isSupportedInExtention(operation)) {
                    this.providerConfiguration = null;
                    return this.getProvider().provides(operation);
                }
                return false;
            }
            return this.getProvider().provides(operation);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof CreateGraphicEditPartOperation) {
                CreateGraphicEditPartOperation o = (CreateGraphicEditPartOperation)operation;
                return this.providerConfiguration.supports(o.getView());
            }
            if (operation instanceof CreateRootEditPartOperation) {
                return this.providerConfiguration.supportsRootEditPart();
            }
            return false;
        }

        public String toString() {
            return this.getElement().getAttribute("class");
        }
    }
}

