/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.info;

import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.IndexDiff;

public class GitItemStateImpl
implements GitItemState {
    private boolean tracked;
    private boolean ignored;
    private boolean dirty;
    private boolean missing;
    @NonNull
    private GitItemState.StagingState staged = GitItemState.StagingState.NOT_STAGED;
    private boolean conflicts;
    private IndexDiff.StageState conflictType;
    private boolean assumeUnchanged;

    @Override
    public boolean isTracked() {
        return this.tracked;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public GitItemState.StagingState getStagingState() {
        return this.staged;
    }

    @Override
    public final boolean isStaged() {
        return this.staged != GitItemState.StagingState.NOT_STAGED;
    }

    @Override
    public boolean hasConflicts() {
        return this.conflicts;
    }

    @Override
    public IndexDiff.StageState getConflictType() {
        return this.conflictType;
    }

    @Override
    public boolean isAssumeUnchanged() {
        return this.assumeUnchanged;
    }

    @Override
    public final boolean hasUnstagedChanges() {
        return !this.isIgnored() && (!this.isTracked() || this.isDirty() || this.isMissing() || this.hasConflicts());
    }

    protected void setStagingState(@NonNull GitItemState.StagingState staged) {
        this.staged = staged;
    }

    protected void setConflicts(boolean conflicts) {
        this.conflicts = conflicts;
    }

    protected void setConflictType(IndexDiff.StageState conflictType) {
        this.conflictType = conflictType;
    }

    protected void setTracked(boolean tracked) {
        this.tracked = tracked;
    }

    protected void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected void setMissing(boolean missing) {
        this.missing = missing;
    }

    protected void setAssumeUnchanged(boolean assumeUnchanged) {
        this.assumeUnchanged = assumeUnchanged;
    }
}

