/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.efs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.UnionInputStream;

public class OursVersionInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    private final int conflictMarkerSize;
    private final boolean diff3Style;
    private InputStream in;
    private boolean initialized;
    private boolean binary;
    private byte[] buffer = new byte[8192];
    private int pos;
    private int end;
    private int lineEnd;
    private boolean isFullLine = true;
    private State state = State.MERGED;
    private State nextState;

    public OursVersionInputStream(InputStream in, int conflictMarkerSize, boolean diff3Style) {
        this.conflictMarkerSize = conflictMarkerSize;
        this.diff3Style = diff3Style;
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.binary) {
            return this.in.read();
        }
        if (this.pos < 0) {
            return -1;
        }
        if (this.pos == this.lineEnd) {
            this.getLine();
            if (this.pos < 0) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.binary) {
            return this.in.read(b, off, len);
        }
        if (this.pos < 0) {
            return -1;
        }
        if (this.pos == this.lineEnd) {
            this.getLine();
            if (this.pos < 0) {
                return -1;
            }
        }
        int l = Math.min(this.lineEnd - this.pos, len);
        System.arraycopy(this.buffer, this.pos, b, off, l);
        this.pos += l;
        return l;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        super.close();
    }

    private void initialize() throws IOException {
        byte[] buf = new byte[8192];
        int len = IO.readFully((InputStream)this.in, (byte[])buf, (int)0);
        if (len <= 0) {
            this.pos = -1;
        } else {
            int i = 0;
            while (i < len) {
                if (buf[i] == 0) {
                    this.binary = true;
                    break;
                }
                ++i;
            }
            this.in = new UnionInputStream(new InputStream[]{new ByteArrayInputStream(buf, 0, len), this.in});
        }
        this.initialized = true;
    }

    private void getLine() throws IOException {
        block11: while (true) {
            if (this.pos == this.end) {
                this.pos = 0;
                this.end = IO.readFully((InputStream)this.in, (byte[])this.buffer, (int)0);
                if (this.end == 0) break;
            }
            int lf = -1;
            int i = this.pos;
            while (i < this.end) {
                if (this.buffer[i] == 10) {
                    lf = i;
                    break;
                }
                ++i;
            }
            boolean wasFullLine = this.isFullLine;
            if (lf < 0) {
                this.isFullLine = false;
                this.lineEnd = this.end;
            } else {
                this.lineEnd = lf + 1;
                this.isFullLine = true;
            }
            if (!wasFullLine) {
                switch (this.state) {
                    case MARKER: {
                        this.pos = this.lineEnd;
                        if (!this.isFullLine) continue block11;
                        this.state = this.nextState;
                        this.nextState = null;
                        continue block11;
                    }
                    case MERGED: 
                    case OURS: {
                        return;
                    }
                    case BASE: 
                    case THEIRS: {
                        this.pos = this.lineEnd;
                        continue block11;
                    }
                }
                throw new IllegalStateException();
            }
            if (!this.isFullLine && this.end == this.buffer.length && this.end - this.pos < this.conflictMarkerSize + 1 && this.pos > 0) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.end - this.pos);
                this.end -= this.pos;
                this.pos = 0;
                int l = IO.readFully((InputStream)this.in, (byte[])this.buffer, (int)this.end);
                int i2 = this.end;
                this.end += l;
                lf = -1;
                while (i2 < this.end) {
                    if (this.buffer[i2] == 10) {
                        lf = i2;
                        break;
                    }
                    ++i2;
                }
                if (lf < 0) {
                    this.lineEnd = this.end;
                    this.isFullLine = false;
                } else {
                    this.lineEnd = lf + 1;
                    this.isFullLine = true;
                }
            }
            switch (this.state) {
                case MERGED: {
                    if (this.isMarker('<')) {
                        this.pos = this.lineEnd;
                        this.state = State.OURS;
                        break;
                    }
                    return;
                }
                case OURS: {
                    if (this.diff3Style && this.isMarker('|')) {
                        this.pos = this.lineEnd;
                        this.state = State.BASE;
                        break;
                    }
                    if (this.isMarker('=')) {
                        this.pos = this.lineEnd;
                        this.state = State.THEIRS;
                        break;
                    }
                    return;
                }
                case BASE: {
                    if (this.isMarker('=')) {
                        this.pos = this.lineEnd;
                        this.state = State.THEIRS;
                        break;
                    }
                    this.pos = this.lineEnd;
                    continue block11;
                }
                case THEIRS: {
                    if (this.isMarker('>')) {
                        this.pos = this.lineEnd;
                        this.state = State.MERGED;
                        break;
                    }
                    this.pos = this.lineEnd;
                    continue block11;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (this.isFullLine) continue;
            this.nextState = this.state;
            this.state = State.MARKER;
        }
        this.pos = -1;
    }

    private boolean isMarker(char marker) {
        if (this.lineEnd - this.pos < this.conflictMarkerSize) {
            return false;
        }
        int i = this.pos + this.conflictMarkerSize - 1;
        while (i >= this.pos) {
            if (this.buffer[i] != marker) {
                return false;
            }
            --i;
        }
        if (this.lineEnd - this.pos > this.conflictMarkerSize) {
            return this.buffer[this.pos + this.conflictMarkerSize] != marker;
        }
        return true;
    }

    private static enum State {
        MARKER,
        MERGED,
        OURS,
        BASE,
        THEIRS;

    }
}

