/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DSEnums {
    private static final Map<String, String> CONFIGURATION_OPTION;
    private static final Map<String, String> REFERENCE_CARDINALITY;
    private static final Map<String, String> REFERENCE_POLICY;
    private static final Map<String, String> REFERENCE_POLICY_OPTION;
    private static final Map<String, String> SERVICE_SCOPE;
    private static final Map<String, String> REFERENCE_SCOPE;
    private static final Map<String, String> FIELD_OPTION;

    static {
        HashMap<String, String> m = new HashMap<String, String>(3);
        m.put("OPTIONAL", "optional");
        m.put("REQUIRE", "require");
        m.put("IGNORE", "ignore");
        CONFIGURATION_OPTION = Collections.unmodifiableMap(m);
        m = new HashMap(4);
        m.put("OPTIONAL", "0..1");
        m.put("MANDATORY", "1..1");
        m.put("MULTIPLE", "0..n");
        m.put("AT_LEAST_ONE", "1..n");
        REFERENCE_CARDINALITY = Collections.unmodifiableMap(m);
        m = new HashMap(2);
        m.put("STATIC", "static");
        m.put("DYNAMIC", "dynamic");
        REFERENCE_POLICY = Collections.unmodifiableMap(m);
        m = new HashMap(2);
        m.put("RELUCTANT", "reluctant");
        m.put("GREEDY", "greedy");
        REFERENCE_POLICY_OPTION = Collections.unmodifiableMap(m);
        m = new HashMap(4);
        m.put("SINGLETON", "singleton");
        m.put("BUNDLE", "bundle");
        m.put("PROTOTYPE", "prototype");
        m.put("DEFAULT", "<<default>>");
        SERVICE_SCOPE = Collections.unmodifiableMap(m);
        m = new HashMap(3);
        m.put("BUNDLE", "bundle");
        m.put("PROTOTYPE", "prototype");
        m.put("PROTOTYPE_REQUIRED", "prototype_required");
        REFERENCE_SCOPE = Collections.unmodifiableMap(m);
        m = new HashMap(2);
        m.put("UPDATE", "update");
        m.put("REPLACE", "replace");
        FIELD_OPTION = Collections.unmodifiableMap(m);
    }

    private DSEnums() {
    }

    public static String getConfigurationPolicy(String literal) {
        return CONFIGURATION_OPTION.get(literal);
    }

    public static String getReferenceCardinality(String literal) {
        return REFERENCE_CARDINALITY.get(literal);
    }

    public static String getReferencePolicy(String literal) {
        return REFERENCE_POLICY.get(literal);
    }

    public static String getReferencePolicyOption(String literal) {
        return REFERENCE_POLICY_OPTION.get(literal);
    }

    public static String getServiceScope(String literal) {
        return SERVICE_SCOPE.get(literal);
    }

    public static String getReferenceScope(String literal) {
        return REFERENCE_SCOPE.get(literal);
    }

    public static String getFieldOption(String literal) {
        return FIELD_OPTION.get(literal);
    }
}

