/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.site;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.site.NewSiteProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.site.NewSiteProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewSiteProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String DEF_PROJECT_NAME = "project-name";
    private NewSiteProjectCreationPage fMainPage;
    private IConfigurationElement fConfig;

    public NewSiteProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWSITEPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PDEUIMessages.NewSiteWizard_wtitle);
    }

    public void addPages() {
        this.fMainPage = new NewSiteProjectCreationPage("main");
        this.fMainPage.setTitle(PDEUIMessages.NewSiteWizard_MainPage_title);
        this.fMainPage.setDescription(PDEUIMessages.NewSiteWizard_MainPage_desc);
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.addPage((IWizardPage)this.fMainPage);
    }

    @Override
    public boolean performFinish() {
        try {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            IProject project = this.fMainPage.getProjectHandle();
            IPath location = this.fMainPage.getLocationPath();
            String webLocation = this.fMainPage.getWebLocation();
            NewSiteProjectCreationOperation op = new NewSiteProjectCreationOperation(this.getShell().getDisplay(), project, location, webLocation);
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.fConfig = config;
    }
}

