/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.imagebrowser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.ImageData;

public class ImageElement {
    private static final Pattern PLUGIN_PATTERN = Pattern.compile("([a-zA-Z0-9]+\\.[a-zA-Z0-9\\.]+)_.+");
    private final ImageData mImageData;
    private final String mPlugin;
    private final String mPath;

    public ImageElement(ImageData image, String plugin, String path) {
        this.mImageData = image;
        this.mPlugin = plugin;
        this.mPath = path;
    }

    public String getFullPlugin() {
        return this.mPlugin;
    }

    public String getPlugin() {
        Matcher matcher = PLUGIN_PATTERN.matcher(this.getFullPlugin());
        if (matcher.matches() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return this.getFullPlugin();
    }

    public String getPath() {
        return this.mPath;
    }

    public ImageData getImageData() {
        return this.mImageData;
    }

    public String getFileName() {
        return new Path(this.mPath).lastSegment();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
        result = 31 * result + (this.mPlugin == null ? 0 : this.mPlugin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageElement other = (ImageElement)obj;
        if (this.mPath == null ? other.mPath != null : !this.mPath.equals(other.mPath)) {
            return false;
        }
        return !(this.mPlugin == null ? other.mPlugin != null : !this.mPlugin.equals(other.mPlugin));
    }
}

