/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.participants;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.CleanSashCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.InitializeSashCommand;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

public class DiControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    @Override
    public String getID() {
        return "org.eclipse.papyrus.infra.services.controlmode.participants.SashControlParticipant";
    }

    @Override
    public int getPriority() {
        return 80;
    }

    @Override
    public boolean provideControlCommand(ControlModeRequest request) {
        EObject objectBeingControl = request.getTargetObject();
        return objectBeingControl != null;
    }

    @Override
    public ICommand getPreControlCommand(ControlModeRequest request) {
        return new CreateControlResource(request, "di");
    }

    @Override
    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new InitializeSashCommand(request);
    }

    @Override
    public boolean provideUnControlCommand(ControlModeRequest request) {
        boolean result = false;
        EObject objectToUncontrol = request.getTargetObject();
        if (objectToUncontrol != null) {
            URI diURI = request.getNewURI().trimFileExtension().appendFileExtension("di");
            ModelSet modelSet = request.getModelSet();
            result = modelSet != null && modelSet.getURIConverter().exists(diURI, null);
        }
        return result;
    }

    @Override
    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        boolean result = this.setDiTargetRequest(request);
        if (result) {
            return this.getClearDiCommand(request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getClearDiCommand(ControlModeRequest request) {
        ModelSet modelSet = request.getModelSet();
        List<Object> affectedFiles = null;
        try {
            Resource associatedResource = modelSet.getAssociatedResource(request.getTargetObject(), "di", true);
            IFile affectedFile = WorkspaceSynchronizer.getFile((Resource)associatedResource);
            affectedFiles = Collections.singletonList(affectedFile);
        }
        catch (Exception resourceException) {
            affectedFiles = Collections.emptyList();
        }
        return new CleanSashCommand(affectedFiles, request);
    }

    protected boolean setDiTargetRequest(ControlModeRequest request) {
        boolean sucessful = false;
        URI diURI = request.getNewURI().trimFileExtension().appendFileExtension("di");
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null) {
            Resource diResource = null;
            try {
                diResource = modelSet.getResource(diURI, true);
            }
            catch (Exception e) {
                diResource = null;
            }
            boolean bl = sucessful = diResource != null;
            if (sucessful) {
                request.setTargetResource(diResource, "di");
            }
        }
        return sucessful;
    }

    @Override
    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return new RemoveControlResourceCommand(request, "di");
    }
}

