/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.pages;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ocl.examples.debug.vm.ui.pages.VMLineBreakpointPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class BreakpointConditionEditor {
    private ProjectionViewer fViewer;
    private String fOldValue;
    private String fErrorMessage;
    private VMLineBreakpointPage fPage;
    private VMLineBreakpoint fBreakpoint;
    private IHandlerService fHandlerService;
    private IHandler fHandler;
    private IHandlerActivation fActivation;
    private IDocumentListener fDocumentListener;

    public BreakpointConditionEditor(Composite parent, VMLineBreakpointPage page) {
        this.fPage = page;
        this.fBreakpoint = this.fPage.getBreakpoint();
        String condition = new String();
        try {
            condition = this.fBreakpoint.getCondition();
            this.fErrorMessage = DebugVMUIMessages.BreakpointConditionEditor_EnterCondition;
            this.fOldValue = "";
            this.fViewer = new ProjectionViewer(parent, null, null, true, 0x2000B00);
            this.fViewer.setInput((Object)parent);
            Document document = new Document();
            this.fViewer.setEditable(true);
            document.set(condition == null ? "" : condition);
            this.fViewer.setDocument((IDocument)document);
            this.fViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(10));
            this.fViewer.getUndoManager().connect((ITextViewer)this.fViewer);
            this.fDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    BreakpointConditionEditor.this.valueChanged();
                }
            };
            this.fViewer.getDocument().addDocumentListener(this.fDocumentListener);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = this.fPage.convertHeightInCharsToPixels(10);
            gd.widthHint = this.fPage.convertWidthInCharsToPixels(40);
            this.fViewer.getControl().setLayoutData((Object)gd);
            this.fHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    if (BreakpointConditionEditor.this.fViewer.canDoOperation(13)) {
                        BreakpointConditionEditor.this.fViewer.doOperation(13);
                    }
                    return null;
                }
            };
            this.fHandlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        }
        catch (CoreException exception) {
            DebugVMUIPlugin.log(exception);
        }
    }

    public String getCondition() {
        return this.fViewer.getDocument().get();
    }

    protected void refreshValidState() {
        if (!this.fViewer.isEditable()) {
            this.fPage.removeErrorMessage(this.fErrorMessage);
        } else {
            String text = this.fViewer.getDocument().get();
            if (text == null || text.trim().length() <= 0) {
                this.fPage.addErrorMessage(this.fErrorMessage);
            } else {
                this.fPage.removeErrorMessage(this.fErrorMessage);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.fViewer.setEditable(enabled);
        this.fViewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(1);
            this.fViewer.getTextWidget().setBackground(color);
            this.fViewer.getTextWidget().setFocus();
            this.fActivation = this.fHandlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", this.fHandler);
        } else {
            Color color = this.fViewer.getControl().getDisplay().getSystemColor(22);
            this.fViewer.getTextWidget().setBackground(color);
            if (this.fActivation != null) {
                this.fHandlerService.deactivateHandler(this.fActivation);
            }
        }
        this.valueChanged();
    }

    protected void valueChanged() {
        String newValue = this.fViewer.getDocument().get();
        if (!newValue.equals(this.fOldValue)) {
            this.fOldValue = newValue;
        }
        this.refreshValidState();
    }

    public void dispose() {
        if (this.fViewer.isEditable()) {
            this.fHandlerService.deactivateHandler(this.fActivation);
        }
        this.fViewer.getDocument().removeDocumentListener(this.fDocumentListener);
    }
}

