/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class KeywordObservableValue
extends AbstractObservableValue
implements IObserving,
ReferenceCountedObservable {
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support((IObservable)this);
    protected Stereotype stereotype;
    protected EditingDomain domain;

    public KeywordObservableValue(Stereotype stereotype, EditingDomain domain) {
        this(Realm.getDefault(), stereotype, domain);
    }

    public KeywordObservableValue(Realm realm, Stereotype stereotype, EditingDomain domain) {
        super(realm);
        this.stereotype = stereotype;
        this.domain = domain;
    }

    public synchronized void dispose() {
        this.stereotype = null;
        super.dispose();
    }

    public Object getObserved() {
        return this.stereotype;
    }

    protected Object doGetValue() {
        return UMLLabelInternationalization.getInstance().getKeywordWithoutUML(this.stereotype);
    }

    protected void doSetValue(Object value) {
        try {
            Command emfCommand = UMLLabelInternationalization.getInstance().getSetKeywordCommand(this.domain, this.stereotype, (String)value, null);
            this.domain.getCommandStack().execute(emfCommand);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Object getValueType() {
        return UMLPackage.eINSTANCE.getNamedElement__GetLabel();
    }

    public void retain() {
        this.refCount.retain();
    }

    public void release() {
        this.refCount.release();
    }

    public void autorelease() {
        this.refCount.autorelease();
    }
}

