/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitecturePlugin;

public class ArchitectureValidator
extends EObjectValidator {
    public static final ArchitectureValidator INSTANCE = new ArchitectureValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.core.architecture";
    public static final int ARCHITECTURE_CONTEXT__CEATION_COMMAND_CLASS_EXISTS = 1;
    public static final int ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS_EXISTS = 2;
    public static final int ARCHITECTURE_CONTEXT__CONTEXT_EXTENSIONS_ARE_CONSISTENT = 3;
    public static final int ARCHITECTURE_CONTEXT__CONTEXT_GENERALIZATION_IS_CONSISTENT = 4;
    public static final int ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS_REQUIRED = 5;
    public static final int ARCHITECTURE_CONTEXT__EXTENSION_CYCLE = 6;
    public static final int ARCHITECTURE_CONTEXT__GENERALIZATION_CYCLE = 7;
    public static final int ARCHITECTURE_CONTEXT__GENERAL_NOT_EXTENDED = 8;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 8;
    protected static final int DIAGNOSTIC_CODE_COUNT = 8;

    protected EPackage getEPackage() {
        return ArchitecturePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateADElement((ADElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateArchitectureDomain((ArchitectureDomain)value, diagnostics, context);
            }
            case 2: {
                return this.validateArchitectureDescriptionLanguage((ArchitectureDescriptionLanguage)value, diagnostics, context);
            }
            case 3: {
                return this.validateStakeholder((Stakeholder)value, diagnostics, context);
            }
            case 4: {
                return this.validateConcern((Concern)value, diagnostics, context);
            }
            case 5: {
                return this.validateArchitectureViewpoint((ArchitectureViewpoint)value, diagnostics, context);
            }
            case 6: {
                return this.validateRepresentationKind((RepresentationKind)value, diagnostics, context);
            }
            case 7: {
                return this.validateArchitectureContext((ArchitectureContext)value, diagnostics, context);
            }
            case 8: {
                return this.validateArchitectureFramework((ArchitectureFramework)value, diagnostics, context);
            }
            case 9: {
                return this.validateArchitectureDescription((ArchitectureDescription)value, diagnostics, context);
            }
            case 10: {
                return this.validateArchitectureDescriptionPreferences((ArchitectureDescriptionPreferences)value, diagnostics, context);
            }
            case 11: {
                return this.validateTreeViewerConfiguration((TreeViewerConfiguration)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateADElement(ADElement adElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(adElement, diagnostics, context);
    }

    public boolean validateArchitectureDomain(ArchitectureDomain architectureDomain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(architectureDomain, diagnostics, context);
    }

    public boolean validateArchitectureDescriptionLanguage(ArchitectureDescriptionLanguage architectureDescriptionLanguage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(architectureDescriptionLanguage, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(architectureDescriptionLanguage, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_ceationCommandClassExists(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_conversionCommandClassExists(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextExtensionsAreConsistent(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextGeneralizationIsConsistent(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_creationCommandClassRequired(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_extensionCycle(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalizationCycle(architectureDescriptionLanguage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalNotExtended(architectureDescriptionLanguage, diagnostics, context);
        }
        return result;
    }

    public boolean validateStakeholder(Stakeholder stakeholder, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stakeholder, diagnostics, context);
    }

    public boolean validateConcern(Concern concern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(concern, diagnostics, context);
    }

    public boolean validateArchitectureViewpoint(ArchitectureViewpoint architectureViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(architectureViewpoint, diagnostics, context);
    }

    public boolean validateRepresentationKind(RepresentationKind representationKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(representationKind, diagnostics, context);
    }

    public boolean validateArchitectureContext(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(architectureContext, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(architectureContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_ceationCommandClassExists(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_conversionCommandClassExists(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextExtensionsAreConsistent(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextGeneralizationIsConsistent(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_creationCommandClassRequired(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_extensionCycle(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalizationCycle(architectureContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalNotExtended(architectureContext, diagnostics, context);
        }
        return result;
    }

    public boolean validateArchitectureContext_ceationCommandClassExists(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.ceationCommandClassExists(diagnostics, context);
    }

    public boolean validateArchitectureContext_conversionCommandClassExists(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.conversionCommandClassExists(diagnostics, context);
    }

    public boolean validateArchitectureContext_contextExtensionsAreConsistent(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.contextExtensionsAreConsistent(diagnostics, context);
    }

    public boolean validateArchitectureContext_contextGeneralizationIsConsistent(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.contextGeneralizationIsConsistent(diagnostics, context);
    }

    public boolean validateArchitectureContext_creationCommandClassRequired(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.creationCommandClassRequired(diagnostics, context);
    }

    public boolean validateArchitectureContext_extensionCycle(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.extensionCycle(diagnostics, context);
    }

    public boolean validateArchitectureContext_generalizationCycle(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.generalizationCycle(diagnostics, context);
    }

    public boolean validateArchitectureContext_generalNotExtended(ArchitectureContext architectureContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return architectureContext.generalNotExtended(diagnostics, context);
    }

    public boolean validateArchitectureFramework(ArchitectureFramework architectureFramework, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(architectureFramework, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(architectureFramework, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_ceationCommandClassExists(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_conversionCommandClassExists(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextExtensionsAreConsistent(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_contextGeneralizationIsConsistent(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_creationCommandClassRequired(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_extensionCycle(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalizationCycle(architectureFramework, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateArchitectureContext_generalNotExtended(architectureFramework, diagnostics, context);
        }
        return result;
    }

    public boolean validateArchitectureDescription(ArchitectureDescription architectureDescription, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(architectureDescription, diagnostics, context);
    }

    public boolean validateArchitectureDescriptionPreferences(ArchitectureDescriptionPreferences architectureDescriptionPreferences, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(architectureDescriptionPreferences, diagnostics, context);
    }

    public boolean validateTreeViewerConfiguration(TreeViewerConfiguration treeViewerConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(treeViewerConfiguration, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return ArchitecturePlugin.INSTANCE;
    }
}

