/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.common.util.DerivedUnionEObjectEList;
import org.eclipse.uml2.uml.Property;

public class NodeInverseRefsServices {
    public static final NodeInverseRefsServices INSTANCE = new NodeInverseRefsServices();

    private NodeInverseRefsServices() {
    }

    public Collection<EObject> getAssociationInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "Association");
    }

    public Collection<EObject> getNodeInverseRefs(DDiagram diagram, String typeName) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        if (diagram instanceof DSemanticDecorator) {
            Session sess = SessionManager.INSTANCE.getSession(((DSemanticDecorator)diagram).getTarget());
            Iterator it = Iterators.transform((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), AbstractDNode.class), (Function)new Function<AbstractDNode, EObject>(){

                public EObject apply(AbstractDNode input) {
                    return input.getTarget();
                }
            });
            while (it.hasNext()) {
                EObject displayedAsANode = (EObject)it.next();
                if (displayedAsANode == null) continue;
                for (EStructuralFeature.Setting xRef : sess.getSemanticCrossReferencer().getInverseReferences(displayedAsANode)) {
                    EObject eObject = xRef.getEObject();
                    if (xRef instanceof DerivedUnionEObjectEList) {
                        for (EObject eObject2 : (List)xRef) {
                            if (!sess.getModelAccessor().eInstanceOf(eObject2, typeName)) continue;
                            result.add(eObject2);
                        }
                    }
                    if (sess.getModelAccessor().eInstanceOf(eObject, typeName)) {
                        result.add(eObject);
                    }
                    if (!(eObject instanceof Property) || ((Property)eObject).getAssociation() == null || !sess.getModelAccessor().eInstanceOf((EObject)((Property)eObject).getAssociation(), typeName)) continue;
                    result.add(((Property)eObject).getAssociation());
                }
            }
        }
        return result;
    }

    public Collection<EObject> getTemplateBindingInverseRefs(DDiagram diagram) {
        return this.getNodeInverseRefs(diagram, "TemplateBinding");
    }
}

