/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.junit.Assert;

public class AbstractDeleteSemanticEdgeTest
extends AbstractSiriusDiagramTests {
    public void deleteEdge(DEdge edgeToDelete, EObject semanticContainer, EReference containmentFeature) {
        this.checkSiriusDiagramSynchronization(false);
        Assert.assertTrue((boolean)(this.fixture.getModel() instanceof Package));
        Element edgeToBeDeleted = (Element)edgeToDelete.getTarget();
        Assert.assertNotNull((String)"We can't find the edge to destroy", (Object)edgeToBeDeleted);
        DiagramEditPart diagramEditpart = this.fixture.getActiveDiagram();
        Diagram diagram = diagramEditpart.getDiagramView();
        Assert.assertNotNull((String)"We can't find the class diagram", (Object)diagram);
        int diagramEdgesSizeBefore = diagram.getEdges().size();
        int featureSizeBefore = this.getContainmentList(semanticContainer, containmentFeature).size();
        this.fixture.applySemanticDeletionTool((DDiagramElement)edgeToDelete);
        this.fixture.flushDisplayEvents();
        Assert.assertFalse((String)"The UML model must not contain the destroyed edge", (boolean)this.getContainmentList(semanticContainer, containmentFeature).contains(edgeToBeDeleted));
        Assert.assertEquals((String)"The UseCase diagram must not contain the view of the edge after the destruction", (long)(diagramEdgesSizeBefore - 1), (long)diagram.getEdges().size());
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertNotNull((String)"The UML model must contain the destroyed edge after undoing the destruction", (Object)edgeToBeDeleted);
        Assert.assertEquals((String)"The diagram must contain the view of the edge after undoing the destruction", (long)diagramEdgesSizeBefore, (long)diagram.getEdges().size());
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((String)"The UML model must not contain the destroyed edge after redoing the destruction", (long)(featureSizeBefore - 1), (long)this.getContainmentList(semanticContainer, containmentFeature).size());
        Assert.assertEquals((String)"The diagram must not contain the view of the edge after redoing the destruction", (long)(diagramEdgesSizeBefore - 1), (long)diagram.getEdges().size());
    }

    private List<? extends Element> getContainmentList(EObject semanticContainer, EReference containmentFeature) {
        return Optional.of(semanticContainer.eGet((EStructuralFeature)containmentFeature)).filter(List.class::isInstance).map(List.class::cast).stream().flatMap(Collection::stream).filter(Element.class::isInstance).map(Element.class::cast).collect(Collectors.toList());
    }
}

