/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.AbstractDropStrategy;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLCompartmentEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReorderListItemsStrategy
extends AbstractDropStrategy {
    private IFigure dropFeedback;

    public String getLabel() {
        return "Reorder list items";
    }

    public String getDescription() {
        return "Reorders items in a list compartment";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.strategy.ReorderListItemsStrategy";
    }

    private ListCompartmentEditPart getTargetEP(EditPart targetEditPart) {
        if (targetEditPart instanceof ListCompartmentEditPart) {
            return (ListCompartmentEditPart)targetEditPart;
        }
        if (targetEditPart.getParent() instanceof ListCompartmentEditPart) {
            return (ListCompartmentEditPart)targetEditPart.getParent();
        }
        return null;
    }

    public Command getCommand(Request request, EditPart targetEditPart) {
        if (!(request instanceof ChangeBoundsRequest)) {
            return null;
        }
        final ListCompartmentEditPart listPart = this.getTargetEP(targetEditPart);
        if (listPart == null) {
            return null;
        }
        final ChangeBoundsRequest dropRequest = (ChangeBoundsRequest)request;
        List objects = dropRequest.getEditParts();
        final List editParts = objects.stream().filter(IPrimaryEditPart.class::isInstance).flatMap(ReorderListItemsStrategy.selectByType(UMLCompartmentEditPart.class)).filter(p -> p.getParent() == listPart).collect(Collectors.toList());
        if (editParts.isEmpty()) {
            return null;
        }
        if (editParts.stream().anyMatch(p -> p.getParent() != listPart)) {
            return null;
        }
        Resource eResource = NotationHelper.findView((Object)listPart).eResource();
        IFile file = ResourceUtils.getFile((Resource)eResource);
        List<Object> modifiedResources = file == null ? Collections.emptyList() : Collections.singletonList(file);
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)listPart);
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "Reorder items", modifiedResources){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EditPart dropBefore = ReorderListItemsStrategy.this.getDropBefore(dropRequest, listPart);
                ListCompartmentEditPart primary = listPart;
                while (primary != null && !(primary instanceof IPrimaryEditPart)) {
                    primary = primary.getParent();
                }
                if (primary == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                if (DiagramEditPartsUtil.isCanonical((EditPart)primary)) {
                    return this.reorderSemantic(listPart, dropBefore);
                }
                return this.reorderGraphical(listPart, dropBefore);
            }

            private CommandResult reorderGraphical(ListCompartmentEditPart listPart2, EditPart dropBefore) {
                EList viewChildren = listPart2.getNotationView().getPersistedChildren();
                View dropBeforeView = NotationHelper.findView((Object)dropBefore);
                for (UMLCompartmentEditPart selected : editParts) {
                    int currentIndex;
                    View view;
                    if (selected == dropBefore || (view = selected.getNotationView()) == null) continue;
                    int targetIndex = dropBeforeView == null ? viewChildren.size() : viewChildren.indexOf((Object)dropBeforeView);
                    if (targetIndex > (currentIndex = viewChildren.indexOf((Object)view))) {
                        --targetIndex;
                    }
                    viewChildren.move(targetIndex, (Object)view);
                }
                return CommandResult.newOKCommandResult();
            }

            private CommandResult reorderSemantic(ListCompartmentEditPart listPart2, EditPart dropAfter) {
                Runnable showInfo = () -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Reorder not supported", (String)"Reordering elements from the diagram is not supported when the diagram is synchronized with the model.\nYou can either disable the \"Sync with model\" mode in the Appearance tab of the properties view, or reorder the semantic model directly (e.g. using the Model Explorer).");
                if (Display.getCurrent() == null) {
                    Display.getDefault().syncExec(showInfo);
                } else {
                    showInfo.run();
                }
                return CommandResult.newCancelledCommandResult();
            }
        });
    }

    private int getDropIndex(ChangeBoundsRequest dropRequest, ListCompartmentEditPart listPart) {
        EditPart dropAfter = this.getDropBefore(dropRequest, listPart);
        return dropAfter == null ? listPart.getChildren().size() : listPart.getChildren().indexOf(dropAfter);
    }

    private EditPart getDropBefore(ChangeBoundsRequest dropRequest, ListCompartmentEditPart listPart) {
        int target = dropRequest.getLocation().y;
        List children = listPart.getChildren();
        EditPart dropBefore = null;
        for (EditPart ep : children) {
            if (!(ep instanceof GraphicalEditPart)) continue;
            IFigure figure = ((GraphicalEditPart)ep).getFigure();
            if (figure.getBounds().y + figure.getBounds().height / 2 <= target) continue;
            dropBefore = ep;
            break;
        }
        return dropBefore;
    }

    private static <T> Function<Object, Stream<? extends T>> selectByType(Class<T> type) {
        return o -> type.isInstance(o) ? Stream.of(type.cast(o)) : Stream.empty();
    }

    @Deprecated
    public int getPriority() {
        return 0;
    }

    public boolean showTargetFeedback(Request request, EditPart targetEditPart) {
        if (this.getCommand(request, targetEditPart) != null) {
            ListCompartmentEditPart targetEP = this.getTargetEP(targetEditPart);
            ChangeBoundsRequest dropRequest = (ChangeBoundsRequest)request;
            EditPart ep = (EditPart)targetEP.getChildren().get(0);
            IFigure sibling = ((GraphicalEditPart)ep).getFigure();
            IFigure figure = sibling.getParent();
            if (this.dropFeedback == null) {
                RectangleFigure rectangle = new RectangleFigure();
                rectangle.setBounds(new Rectangle(0, 0, 100, 1));
                int border = figure.getBorder().getInsets(figure).getWidth();
                rectangle.getBounds().setWidth(figure.getBounds().width() - border);
                rectangle.setForegroundColor(Display.getCurrent().getSystemColor(16));
                rectangle.setBackgroundColor(Display.getCurrent().getSystemColor(16));
                rectangle.setVisible(true);
                rectangle.setFill(true);
                rectangle.setLocation(new Point(30, 300));
                this.dropFeedback = rectangle;
                figure.add(this.dropFeedback);
            }
            int index = this.getDropIndex(dropRequest, this.getTargetEP(targetEditPart));
            figure.add(this.dropFeedback, index);
            return true;
        }
        return false;
    }

    public boolean eraseTargetFeedback(Request request, EditPart targetEditPart) {
        if (this.dropFeedback != null && request instanceof ChangeBoundsRequest) {
            if (this.dropFeedback.getParent() != null) {
                this.dropFeedback.getParent().getChildren().remove(this.dropFeedback);
            }
            this.dropFeedback = null;
            return true;
        }
        return false;
    }
}

