/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.draw2d;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class LaneLayout
extends AbstractHintLayout {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private int myLaneOrientation;
    private Insets myInsets;
    private final Transposer myTransposer;
    private final HashMap<IFigure, Object> myConstraints = new HashMap();

    public LaneLayout() {
        this(0, NO_INSETS);
    }

    public LaneLayout(Insets insets) {
        this(0, insets);
    }

    public LaneLayout(int laneOrientation, Insets insets) {
        this.myTransposer = new Transposer();
        this.setLaneOrientation(laneOrientation);
        this.setInsets(insets);
    }

    public void setLaneOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Incorrect lane orientation constant: " + orientation);
        }
        this.myTransposer.setEnabled(orientation == 1);
        this.myLaneOrientation = orientation;
    }

    public int getLaneOrientation() {
        return this.myLaneOrientation;
    }

    public void setInsets(Insets insets) {
        this.myInsets = insets != null ? insets : NO_INSETS;
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        int childWHint;
        Insets insets = container.getInsets();
        List children = container.getChildren();
        int n = this.getLaneOrientation() == 0 ? Math.max(0, wHint - insets.getWidth()) : (childWHint = wHint - insets.getWidth() > 0 ? wHint - insets.getWidth() / children.size() : wHint);
        int childHHint = this.getLaneOrientation() == 1 ? Math.max(0, hHint - insets.getHeight()) : (hHint - insets.getHeight() > 0 ? hHint - insets.getHeight() / children.size() : hHint);
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle constraint = (Rectangle)this.getConstraint(child);
            Dimension childSize = this.myTransposer.t(this.myTransposer.t((Rectangle)constraint).height > -1 ? constraint.getSize() : child.getMinimumSize(childWHint, childHHint));
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return this.myTransposer.t(new Dimension(width, height)).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int childWHint;
        Insets insets = container.getInsets();
        List children = container.getChildren();
        int n = this.getLaneOrientation() == 0 ? Math.max(0, wHint - insets.getWidth()) : (childWHint = wHint - insets.getWidth() > 0 ? wHint - insets.getWidth() / children.size() : wHint);
        int childHHint = this.getLaneOrientation() == 1 ? Math.max(0, hHint - insets.getHeight()) : (hHint - insets.getHeight() > 0 ? hHint - insets.getHeight() / children.size() : hHint);
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle constraint = (Rectangle)this.getConstraint(child);
            Dimension childSize = this.myTransposer.t(this.myTransposer.t((Rectangle)constraint).height > -1 ? constraint.getSize() : child.getPreferredSize(childWHint, childHHint));
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return this.myTransposer.t(new Dimension(width, height)).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        if (constraint != null) {
            this.myConstraints.put(child, constraint);
        }
    }

    public Object getConstraint(IFigure child) {
        return this.myConstraints.get(child);
    }

    public void remove(IFigure child) {
        super.remove(child);
        this.myConstraints.remove(child);
    }

    public void layout(IFigure container) {
        List children = container.getChildren();
        int numChildren = children.size();
        if (numChildren > 0) {
            Dimension[] prefSizes = new Dimension[numChildren];
            Dimension[] minSizes = new Dimension[numChildren];
            Insets insets = this.getInsets();
            int wHint = this.getLaneOrientation() == 0 ? Math.max(0, container.getClientArea((Rectangle)Rectangle.SINGLETON).width - insets.getWidth()) : -1;
            int hHint = this.getLaneOrientation() == 1 ? Math.max(0, container.getClientArea((Rectangle)Rectangle.SINGLETON).height - insets.getHeight()) : -1;
            int totalPrefHeight = 0;
            int nonExpansibleNum = 0;
            int i = 0;
            while (i < numChildren) {
                IFigure child = (IFigure)children.get(i);
                Rectangle constraint = (Rectangle)this.getConstraint(child);
                boolean isResizedByUser = this.myTransposer.t((Rectangle)constraint).height > -1;
                prefSizes[i] = this.myTransposer.t(isResizedByUser ? constraint.getSize() : child.getPreferredSize(wHint, hHint));
                minSizes[i] = this.myTransposer.t(isResizedByUser ? constraint.getSize() : child.getMinimumSize(wHint, hHint));
                totalPrefHeight += prefSizes[i].height;
                if (isResizedByUser) {
                    ++nonExpansibleNum;
                }
                ++i;
            }
            Rectangle clientArea = this.myTransposer.t(container.getClientArea().getCopy().crop(insets));
            int expansion = totalPrefHeight < clientArea.height && children.size() > nonExpansibleNum ? (clientArea.height - totalPrefHeight) / (children.size() - nonExpansibleNum) : 0;
            int x = clientArea.x;
            int y = clientArea.y;
            int i2 = 0;
            while (i2 < numChildren) {
                int prefHeight = prefSizes[i2].height;
                int prefWidth = prefSizes[i2].width;
                int minWidth = minSizes[i2].width;
                Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
                IFigure child = (IFigure)children.get(i2);
                Rectangle constraint = this.myTransposer.t((Rectangle)this.getConstraint(child));
                boolean isResizedByUser = constraint.height > -1;
                newBounds.width = Math.max(minWidth, clientArea.width);
                if (isResizedByUser) {
                    if (numChildren == nonExpansibleNum && totalPrefHeight < clientArea.height && i2 == numChildren - 1) {
                        newBounds.height += clientArea.height - totalPrefHeight;
                    }
                } else {
                    newBounds.height += expansion;
                }
                child.setBounds(this.myTransposer.t(newBounds));
                y += newBounds.height;
                ++i2;
            }
        }
    }
}

