/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.clazz.services;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class ClassDiagramOutsideMappingServices {
    public boolean isOutsideOfTheDiagramContext(NamedElement element, EObject aContainerView) {
        DDiagram parentDiagram;
        if (aContainerView instanceof DSemanticDiagram) {
            return this.isOutsideOfTheDiagramContext(element, (DSemanticDiagram)aContainerView);
        }
        if (aContainerView instanceof DDiagramElement && (parentDiagram = ((DDiagramElement)aContainerView).getParentDiagram()) instanceof DSemanticDiagram) {
            return this.isOutsideOfTheDiagramContext(element, (DSemanticDiagram)parentDiagram);
        }
        return false;
    }

    private boolean isOutsideOfTheDiagramContext(NamedElement element, DSemanticDiagram diagram) {
        Assert.isTrue((boolean)(diagram.getTarget() instanceof NamedElement), (String)"We expected a NamedElement as target for a Diagram");
        NamedElement target = (NamedElement)diagram.getTarget();
        EList namespaces = element.allNamespaces();
        return !namespaces.contains(target);
    }

    public boolean isReadOnly(EObject element) {
        return EMFHelper.isReadOnly((EObject)element);
    }

    public Collection<EObject> getOutsideClasses(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getClass_());
    }

    public Collection<EObject> getOutsideComponents(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getComponent());
    }

    public Collection<EObject> getOutsideDataTypes(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getDataType());
    }

    public Collection<EObject> getOutsideEnumerations(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getEnumeration());
    }

    public Collection<EObject> getOutsideInterfaces(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getInterface());
    }

    public Collection<EObject> getOutsidePackages(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getPackage());
    }

    public Collection<EObject> getOutsidePrimitiveTypes(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getPrimitiveType());
    }

    public Collection<EObject> getOutsideModels(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getModel());
    }

    public Collection<EObject> getOutsideSignals(EObject self, DSemanticDiagram diagram) {
        return this.getOutsideElements(self, diagram, UMLPackage.eINSTANCE.getSignal());
    }

    private Collection<EObject> getOutsideElements(EObject self, DSemanticDiagram diagram, EClass wantedType) {
        ArrayList<EObject> wantedElements = new ArrayList<EObject>();
        Resource currentResource = self.eResource();
        ResourceSet set = currentResource.getResourceSet();
        for (Resource resource : set.getResources()) {
            if (!(resource instanceof UMLResource)) continue;
            Collection<NamedElement> elements = this.getAllElementsByType((UMLResource)resource, wantedType);
            if (resource == currentResource) {
                for (NamedElement current : elements) {
                    if (!this.isOutsideOfTheDiagramContext(current, diagram)) continue;
                    wantedElements.add((EObject)current);
                }
                continue;
            }
            wantedElements.addAll(elements);
        }
        return wantedElements;
    }

    private Collection<NamedElement> getAllElementsByType(UMLResource resource, EClass wantedEClassType) {
        ArrayList<NamedElement> elements = new ArrayList<NamedElement>();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (!(current instanceof NamedElement) || current.eClass() != wantedEClassType) continue;
            elements.add((NamedElement)current);
        }
        return elements;
    }
}

