/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.internal.commands;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PageLayoutStorageState
extends ToggleState
implements IPartListener,
PropertyChangeListener {
    private IPartService partService = null;
    private Reference<IMultiDiagramEditor> activeEditor;

    public PageLayoutStorageState() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.partService = window.getPartService();
            if (this.partService != null) {
                this.partService.addPartListener((IPartListener)this);
                this.update(this.partService.getActivePart());
            }
        }
    }

    public void dispose() {
        if (this.partService != null) {
            this.partService.removePartListener((IPartListener)this);
        }
        super.dispose();
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.activeEditor != null && this.activeEditor.get() == part) {
            this.update(null);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.update(part);
    }

    private void update(IWorkbenchPart part) {
        boolean state = true;
        this.unhookSashModelListener();
        this.activeEditor = null;
        if (part instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor editor = (IMultiDiagramEditor)part;
            this.activeEditor = new WeakReference<IMultiDiagramEditor>(editor);
            state = this.isPrivateLayout(editor);
        }
        this.hookSashModelListener();
        this.setValue(state);
    }

    public Object getValue() {
        IMultiDiagramEditor editor = this.activeEditor == null ? null : this.activeEditor.get();
        return editor != null ? Boolean.valueOf(this.isPrivateLayout(editor)) : super.getValue();
    }

    boolean isPrivateLayout(IMultiDiagramEditor editor) {
        ModelSet modelSet = (ModelSet)((EditingDomain)editor.getAdapter(EditingDomain.class)).getResourceSet();
        SashModel sashModel = SashModelUtils.getSashModel((ModelSet)modelSet);
        return sashModel == null || !sashModel.isLegacyMode();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block7: {
            if (!(evt.getSource() instanceof SashModel)) break block7;
            switch (evt.getPropertyName()) {
                case "legacyMode": {
                    this.setValue((Boolean)evt.getNewValue() == false);
                }
            }
        }
    }

    private SashModel getSashModel() {
        IMultiDiagramEditor editor;
        SashModel result = null;
        if (this.activeEditor != null && (editor = this.activeEditor.get()) != null) {
            result = SashModelUtils.getSashModel((ServicesRegistry)editor.getServicesRegistry());
        }
        return result;
    }

    private void unhookSashModelListener() {
        SashModel sash = this.getSashModel();
        if (sash != null) {
            sash.removePropertyChangeListener("legacyMode", (PropertyChangeListener)this);
        }
    }

    private void hookSashModelListener() {
        SashModel sash = this.getSashModel();
        if (sash != null) {
            sash.addPropertyChangeListener("legacyMode", (PropertyChangeListener)this);
        }
    }
}

