/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationFactory;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class InternationalizationKeyResolver {
    protected static final String LABEL_DIAGRAM_PREFIX_QN = "_labelDiagram_";
    protected static final String LABEL_TABLE_PREFIX_QN = "_labelTable_";
    public static final String LABEL_PREFIX = "_label_";
    protected static final String NOTATION_FILE_EXTENSION = "notation";

    public InternationalizationEntry createInternationalizationEntryByKey(String key, ResourceSet resourceSet, URI uri) {
        InternationalizationEntry entry = InternationalizationFactory.eINSTANCE.createInternationalizationEntry();
        if (key.startsWith(LABEL_DIAGRAM_PREFIX_QN)) {
            String keyWithoutPrefix = key.substring(LABEL_DIAGRAM_PREFIX_QN.length());
            String qualifiedName = keyWithoutPrefix.substring(0, keyWithoutPrefix.indexOf(LABEL_PREFIX));
            String diagramName = keyWithoutPrefix.substring(keyWithoutPrefix.indexOf(LABEL_PREFIX) + LABEL_PREFIX.length());
            Resource notationResource = resourceSet.getResource(uri.trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION), true);
            if (notationResource != null && notationResource.getContents() != null && !notationResource.getContents().isEmpty()) {
                Diagram foundDiagram = QualifiedNameUtils.getDiagram(notationResource, diagramName, qualifiedName);
                entry.setKey(foundDiagram);
            }
        } else if (key.startsWith(LABEL_TABLE_PREFIX_QN)) {
            String keyWithoutPrefix = key.substring(LABEL_TABLE_PREFIX_QN.length());
            String qualifiedName = keyWithoutPrefix.substring(0, keyWithoutPrefix.indexOf(LABEL_PREFIX));
            String tableName = keyWithoutPrefix.substring(keyWithoutPrefix.indexOf(LABEL_PREFIX) + LABEL_PREFIX.length());
            Resource umlResource = resourceSet.getResource(uri.trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION), true);
            if (umlResource != null && umlResource.getContents() != null && !umlResource.getContents().isEmpty()) {
                Table foundTable = QualifiedNameUtils.getTable(umlResource, tableName, qualifiedName);
                entry.setKey(foundTable);
            }
        } else {
            entry.setKey(key);
        }
        return entry;
    }

    public String getKey(InternationalizationEntry entry) {
        StringBuilder result = new StringBuilder();
        if (entry.getKey() instanceof Diagram) {
            result.append(LABEL_DIAGRAM_PREFIX_QN);
            Diagram diagram = (Diagram)entry.getKey();
            EObject diagramContainer = diagram.getElement();
            result.append(QualifiedNameUtils.getQualifiedName(diagramContainer));
            result.append(LABEL_PREFIX);
            result.append(diagram.getName());
        } else if (entry.getKey() instanceof Table) {
            result.append(LABEL_TABLE_PREFIX_QN);
            Table table = (Table)entry.getKey();
            EObject tableContainer = table.getOwner();
            result.append(QualifiedNameUtils.getQualifiedName(tableContainer));
            result.append(LABEL_PREFIX);
            result.append(table.getName());
        } else {
            result.append((String)entry.getKey());
        }
        return result.toString();
    }

    public void dispose() {
    }
}

