/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class DefaultSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, view);
        }
        return super.getCommand(request);
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? semanticCommand : null;
        }
        return semanticCommand;
    }

    protected IEditCommandRequest completeRequest(IEditCommandRequest request) {
        String type;
        Object model;
        ConnectionEditPart ep;
        IEditCommandRequest result = super.completeRequest(request);
        if (result instanceof DestroyReferenceRequest && ((IGraphicalEditPart)this.getHost()).resolveSemanticElement() == null && this.getHost() instanceof ConnectionEditPart && (ep = (ConnectionEditPart)this.getHost()).isSemanticConnection() && (model = ep.getModel()) instanceof Connector && (type = ((Connector)model).getType()) != null) {
            result.setParameter("VISUAL_ID", (Object)type);
            result.setParameter("AFFECTED_VIEW", model);
        }
        return result;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req, req.getElementType());
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        IElementType elementType = req.getElementType();
        if (elementType != null && elementType.getEClass() == null) {
            return this.getDefaultSemanticCommand((IEditCommandRequest)req, elementType);
        }
        return this.getDefaultSemanticCommand((IEditCommandRequest)req);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req);
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return this.getDestroyReferenceCommand(req, req.getContainer());
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req, Object context) {
        return this.getDefaultSemanticCommand((IEditCommandRequest)req, context);
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        EObject context = req.getReferenceOwner();
        return this.getDefaultSemanticCommand((IEditCommandRequest)req, context);
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((EObject)req.getRelationship());
        if (commandService == null) {
            return UnexecutableCommand.INSTANCE;
        }
        View newView = (View)this.getHost().getModel();
        req.setParameter("RECONNECT_END_VIEW", (Object)newView);
        ICommand semanticCommand = commandService.getEditCommand((IEditCommandRequest)req);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return this.getGEFWrapper(semanticCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    private Command getDefaultSemanticCommand(IEditCommandRequest req) {
        return this.getDefaultSemanticCommand(req, null);
    }

    private Command getDefaultSemanticCommand(IEditCommandRequest req, Object context) {
        try {
            ICommand semanticCommand;
            IClientContext clientContext = TypeContext.getContext((EditingDomain)this.getEditingDomain());
            IElementEditService commandService = context != null ? ElementEditServiceUtils.getCommandProvider((Object)context, (IClientContext)clientContext) : ElementEditServiceUtils.getCommandProvider((Object)((IGraphicalEditPart)this.getHost()).resolveSemanticElement(), (IClientContext)clientContext);
            if (commandService != null && (semanticCommand = commandService.getEditCommand(req)) != null && semanticCommand.canExecute()) {
                return this.getGEFWrapper(semanticCommand);
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

