/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;

public class PDEClassContributionProvider
implements IClassContributionProvider {
    private final SearchEngine searchEngine = new SearchEngine();

    public void findContribution(IClassContributionProvider.Filter filter, final IClassContributionProvider.ContributionResultHandler handler) {
        boolean followReferences = true;
        if (filter.getSearchScope().contains(ResourceSearchScope.PROJECT) && !filter.getSearchScope().contains(ResourceSearchScope.REFERENCES)) {
            followReferences = false;
        }
        IJavaSearchScope scope = null;
        if (!followReferences) {
            IJavaProject javaProject = JavaCore.create((IProject)filter.project);
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])roots, (boolean)false);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        } else {
            scope = filter.project != null ? PDEJavaHelper.getSearchScope((IProject)filter.project) : SearchEngine.createWorkspaceScope();
        }
        char[] packageName = null;
        char[] typeName = null;
        Object currentContent = filter.namePattern;
        int index = ((String)currentContent).lastIndexOf(46);
        if (index == -1) {
            typeName = ((String)currentContent).toCharArray();
            if (((String)currentContent).startsWith("*")) {
                if (!((String)currentContent).endsWith("*")) {
                    currentContent = (String)currentContent + "*";
                }
                typeName = ((String)currentContent).toCharArray();
                packageName = "*".toCharArray();
            }
        } else if (index + 1 == ((String)currentContent).length()) {
            typeName = "".toCharArray();
            packageName = ((String)currentContent).substring(0, index).toCharArray();
        } else {
            typeName = ((String)currentContent).substring(index + 1).toCharArray();
            packageName = ((String)currentContent).substring(0, index).toCharArray();
        }
        TypeNameRequestor req = new TypeNameRequestor(){

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                IProject project;
                IFile f;
                boolean isEnclosed = enclosingTypeNames != null && enclosingTypeNames.length > 0;
                String ePrefix = isEnclosed ? new String(enclosingTypeNames[0]) + "$" : "";
                String cName = ePrefix + new String(simpleTypeName);
                String pName = new String(packageName);
                String content = pName.length() == 0 ? cName : pName + "." + cName;
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                if (resource != null && (f = (project = resource.getProject()).getFile("/META-INF/MANIFEST.MF")) != null && f.exists()) {
                    try {
                        Throwable throwable = null;
                        Object var15_18 = null;
                        try (BufferedReader r = new BufferedReader(new InputStreamReader(f.getContents()));){
                            String line;
                            while ((line = r.readLine()) != null) {
                                if (!line.startsWith("Bundle-SymbolicName:")) continue;
                                int start = line.indexOf(58);
                                int end = line.indexOf(59);
                                if (end == -1) {
                                    end = line.length();
                                }
                                IClassContributionProvider.ContributionData data = new IClassContributionProvider.ContributionData(line.substring(start + 1, end).trim(), content, "Java", null);
                                handler.result(data);
                                break;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            this.searchEngine.searchAllTypeNames(packageName, 2, typeName, 130, 5, scope, req, 3, null);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        handler.moreResults(0, filter);
    }
}

