/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.properties.AbstractPropertySection;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.CompositeEObjectPropertySource;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.tools.api.properties.SiriusExtensiblePropertySource;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class SemanticPropertySection
extends AbstractPropertySection
implements IPropertySourceProvider {
    private List<Object> transformedSelection;
    private IWorkbenchPart part;

    public IPropertySource getPropertySource(Object object) {
        Object propSrc = null;
        if (object instanceof IPropertySource) {
            propSrc = (IPropertySource)object;
        } else if (object instanceof DDiagramElement) {
            DDiagramElement diagramElement = (DDiagramElement)object;
            Iterator iterElementsToDestroy = diagramElement.getSemanticElements().iterator();
            CompositeEObjectPropertySource propertySource = new CompositeEObjectPropertySource();
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)diagramElement);
            while (iterElementsToDestroy.hasNext()) {
                IItemPropertySource ips;
                AdapterFactory af;
                EObject semanticElement = (EObject)iterElementsToDestroy.next();
                if (accessor.isExtension(semanticElement) || (af = this.getAdapterFactory(semanticElement)) == null || (ips = (IItemPropertySource)af.adapt((Notifier)semanticElement, IItemPropertySource.class)) == null) continue;
                SiriusExtensiblePropertySource targetPropertySource = new SiriusExtensiblePropertySource((Object)semanticElement, ips);
                propertySource.addPropertySource(semanticElement, (IPropertySource)targetPropertySource);
            }
            propSrc = propertySource;
        } else if (object instanceof DSemanticDecorator) {
            IItemPropertySource ips;
            AdapterFactory af;
            EObject semanticElement;
            CompositeEObjectPropertySource propertySource = new CompositeEObjectPropertySource();
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)object);
            if (!accessor.isExtension(semanticElement = ((DSemanticDecorator)object).getTarget()) && (af = this.getAdapterFactory(semanticElement)) != null && (ips = (IItemPropertySource)af.adapt((Notifier)semanticElement, IItemPropertySource.class)) != null) {
                SiriusExtensiblePropertySource targetPropertySource = new SiriusExtensiblePropertySource((Object)semanticElement, ips);
                propertySource.addPropertySource(semanticElement, (IPropertySource)targetPropertySource);
            }
            propSrc = propertySource;
        } else {
            IItemPropertySource ips;
            AdapterFactory af = this.getAdapterFactory(object);
            if (af != null && (ips = (IItemPropertySource)af.adapt(object, IItemPropertySource.class)) != null) {
                return new SiriusExtensiblePropertySource(object, ips);
            }
            if (object instanceof IAdaptable) {
                propSrc = (IPropertySource)((IAdaptable)object).getAdapter(IPropertySource.class);
            }
        }
        return propSrc;
    }

    @Override
    protected IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    protected Object transformSelection(Object selection) {
        EObject target;
        Object object = selection;
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        } else if (object instanceof IAdaptable) {
            object = ((IAdaptable)object).getAdapter(View.class);
        }
        if (object instanceof View) {
            object = ((View)object).getElement();
        }
        if (object instanceof DSemanticDecorator && ((target = ((DSemanticDecorator)object).getTarget()) == null || target.eResource() == null)) {
            object = null;
        }
        return object;
    }

    @Override
    public void setInput(IWorkbenchPart workbenchPart, ISelection selection) {
        this.part = workbenchPart;
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(workbenchPart, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        this.transformedSelection = new ArrayList<Object>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (r == null) continue;
            this.transformedSelection.add(r);
        }
        super.setInput(workbenchPart, (ISelection)new StructuredSelection(this.transformedSelection));
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        AdapterFactory adapterFactory = null;
        if (object != null) {
            adapterFactory = this.part instanceof DDiagramEditor ? ((DDiagramEditor)this.part).getAdapterFactory() : DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();
        }
        return adapterFactory;
    }

    @Override
    public void refresh() {
        if (this.transformedSelection != null) {
            Iterator<Object> inputs = this.transformedSelection.iterator();
            boolean isValid = true;
            while (inputs.hasNext() && isValid) {
                Resource resource;
                Object input = inputs.next();
                if (!(input instanceof DSemanticDecorator) || (resource = ((DSemanticDecorator)input).eResource()) != null && resource.getResourceSet() != null) continue;
                isValid = false;
            }
            if (!isValid) {
                this.setInput(this.part, (ISelection)StructuredSelection.EMPTY);
            }
        }
        super.refresh();
    }

    @Override
    public Object getSelectedObject() {
        Object result = null;
        if (!this.transformedSelection.isEmpty()) {
            result = this.transformedSelection.get(0);
        }
        return result;
    }

    @Override
    public void dispose() {
        this.transformedSelection = null;
        this.part = null;
        super.dispose();
    }
}

