/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.internal;

import aQute.bnd.service.clipboard.Clipboard;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;

@Component(service={Clipboard.class})
public class SWTClipboard
implements Clipboard {
    private static final Transfer[] TEXT_TRANSFER = new Transfer[]{TextTransfer.getInstance()};

    public <T> boolean copy(T content) {
        Display d = Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
        AtomicBoolean ok = new AtomicBoolean();
        d.syncExec(() -> {
            org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(d);
            if (content instanceof String) {
                cb.setContents(new Object[]{content}, TEXT_TRANSFER);
                ok.set(true);
            }
        });
        return ok.get();
    }

    public <T> Optional<T> paste(Class<T> type) {
        Display d = Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
        AtomicReference ok = new AtomicReference(Optional.empty());
        d.syncExec(() -> {
            org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(null);
            if (type == String.class) {
                String data = (String)cb.getContents(TEXT_TRANSFER[0]);
                ok.set(Optional.ofNullable(data));
            }
        });
        return ok.get();
    }
}

