/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.internal;

import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Verifier;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;

@Component(service={WeavingHook.class})
public class Auxiliary
implements WeavingHook {
    private final BundleTracker<Bundle> tracker;
    private final Deque<String> delta = new ConcurrentLinkedDeque<String>();

    @Activate
    public Auxiliary(BundleContext context) {
        this.tracker = new BundleTracker<Bundle>(context, 44, null){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                if (!Auxiliary.this.doImport((String)bundle.getHeaders().get("Export-Package"))) {
                    return null;
                }
                return (Bundle)super.addingBundle(bundle, event);
            }
        };
        this.tracker.open();
    }

    private boolean doImport(String exports) {
        if (exports == null || exports.isEmpty()) {
            return false;
        }
        Parameters out = new Parameters();
        Parameters p = new Parameters(exports);
        for (Map.Entry e : p.entrySet()) {
            VersionRange range;
            String plugins;
            Attrs attrs = (Attrs)e.getValue();
            if (attrs == null || (plugins = attrs.get("bnd-plugins")) == null || !plugins.isEmpty() && !"true".equalsIgnoreCase(plugins) && Verifier.isVersionRange((String)plugins) && !(range = new VersionRange(plugins)).includes(new Version(3, 0, 0))) continue;
            String v = attrs.getVersion();
            if (v == null) {
                v = "0";
            }
            Iterator i = attrs.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!key.endsWith(":")) continue;
                i.remove();
            }
            if (Verifier.isVersion((String)v)) {
                Version version = new Version(v);
                attrs.put("version", new VersionRange('[', version, version, ']').toString());
            }
            out.put((String)e.getKey(), attrs);
        }
        if (out.isEmpty()) {
            return false;
        }
        this.delta.offerLast(out.toString());
        return true;
    }

    public void weave(WovenClass wovenClass) {
        String dynamicImport;
        if (this.delta.isEmpty()) {
            return;
        }
        BundleWiring wiring = wovenClass.getBundleWiring();
        if (wiring == null) {
            return;
        }
        if (wiring.getBundle() != FrameworkUtil.getBundle(Workspace.class)) {
            return;
        }
        List dynamicImports = wovenClass.getDynamicImports();
        while ((dynamicImport = this.delta.pollFirst()) != null) {
            dynamicImports.add(dynamicImport);
        }
    }

    @Deactivate
    public void close() throws IOException {
        this.tracker.close();
    }
}

