/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ICreator;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.UMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementCreator
implements ICreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementCreator.class);
    private final IElementConfigurer elementInitializer;
    private IFeatureModifier featureModifier;

    public ElementCreator(IElementConfigurer elementInitializer, IFeatureModifier featureModifier) {
        this.elementInitializer = elementInitializer;
        this.featureModifier = featureModifier;
    }

    public static ElementCreator buildDefault(ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return new ElementCreator(new ElementConfigurer(), new ElementFeatureModifier(crossRef, editableChecker));
    }

    private CreationStatus genericCreate(EObject parent, String type, String referenceName) {
        CreationStatus result;
        EClass eClass = UMLHelper.toEClass(type);
        if (eClass != null) {
            EObject newInstance = UMLFactory.eINSTANCE.create(eClass);
            Status status = this.featureModifier.addValue(parent, referenceName, newInstance);
            if (status.getState() == State.DONE) {
                if (this.elementInitializer != null) {
                    this.elementInitializer.configure(newInstance, parent);
                }
                result = CreationStatus.createOKStatus(newInstance);
            } else {
                result = status.getState() == State.FAILED ? CreationStatus.createFailingStatus(status.getMessage()) : CreationStatus.NOTHING;
            }
        } else {
            result = CreationStatus.createFailingStatus(MessageFormat.format("Invalid EClass name {0}", type));
        }
        return result;
    }

    @Override
    public CreationStatus create(EObject parent, String type, String referenceName) {
        if (parent == null || type == null || referenceName == null) {
            return null;
        }
        return this.genericCreate(parent, type, referenceName);
    }
}

