/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.create;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.IDomainBasedEdgeCreator;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeInitializer;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.UMLFactory;

public class ElementBasedEdgeCreator
implements IDomainBasedEdgeCreator {
    private final IDomainBasedEdgeContainerProvider containerProvider;
    private final IDomainBasedEdgeInitializer edgeInitializer;
    private final IElementConfigurer elementInitializer;
    private final IFeatureModifier featureModifier;

    public ElementBasedEdgeCreator(IDomainBasedEdgeContainerProvider containerProvider, IDomainBasedEdgeInitializer edgeInitializer, IElementConfigurer elementInitializer, IFeatureModifier featureModifier) {
        this.containerProvider = containerProvider;
        this.edgeInitializer = edgeInitializer;
        this.elementInitializer = elementInitializer;
        this.featureModifier = featureModifier;
    }

    @Override
    public CreationStatus createDomainBasedEdge(EObject semanticEdgeSource, EObject semanticEdgeTarget, String type, String referenceName, IViewQuerier representionQuery, Object sourceView, Object targetView) {
        EObject container;
        EClass eClass;
        EObject newInstance;
        EClass eClassifier = UMLHelper.toEClass(type);
        CreationStatus result = eClassifier instanceof EClass ? ((newInstance = UMLFactory.eINSTANCE.create(eClass = eClassifier)) != null ? ((container = this.containerProvider.getContainer(semanticEdgeSource, semanticEdgeTarget, newInstance, representionQuery, sourceView, targetView)) != null ? this.addToContainer(container, referenceName, newInstance, semanticEdgeSource, semanticEdgeTarget, representionQuery, sourceView, targetView) : CreationStatus.createFailingStatus(MessageFormat.format("Unable to find a proper container for a new {0}", type))) : CreationStatus.createFailingStatus(MessageFormat.format("Unable to create a UML element of type {0}", type))) : CreationStatus.createFailingStatus(MessageFormat.format("Unkonw type {0}", type));
        return result;
    }

    private CreationStatus addToContainer(EObject container, String referenceName, EObject newInstance, EObject semanticEdgeSource, EObject semanticEdgeTarget, IViewQuerier representionQuery, Object sourceView, Object targetView) {
        Status status = this.featureModifier.addValue(container, referenceName, newInstance);
        State state = status.getState();
        return switch (state) {
            case State.DONE -> {
                this.edgeInitializer.initialize(newInstance, semanticEdgeSource, semanticEdgeTarget, representionQuery, sourceView, targetView);
                this.elementInitializer.configure(newInstance, container);
                yield CreationStatus.createOKStatus(newInstance);
            }
            case State.FAILED -> CreationStatus.createFailingStatus(MessageFormat.format("Unable to add the new element in {0}using refence {1}", container, referenceName));
            case State.NOTHING -> CreationStatus.createOKStatus(null);
            default -> throw new IllegalStateException("Unkown state " + String.valueOf((Object)state));
        };
    }
}

