/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChange;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.PersistenceUpdateDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.RowDeleteDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.RowInsertDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.TemporaryDataProvider;
import org.eclipse.nebula.widgets.nattable.datachange.TemporaryUpdateDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.command.DiscardDataChangesCommandHandler;
import org.eclipse.nebula.widgets.nattable.datachange.command.SaveDataChangesCommandHandler;
import org.eclipse.nebula.widgets.nattable.datachange.config.DefaultDataChangeConfiguration;
import org.eclipse.nebula.widgets.nattable.datachange.event.DiscardDataChangesCompletedEvent;
import org.eclipse.nebula.widgets.nattable.datachange.event.SaveDataChangesCompletedEvent;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChangeLayer
extends AbstractIndexLayerTransform {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangeLayer.class);
    public static final String DIRTY = "DIRTY";
    protected final List<DataChangeHandler> dataChangeHandler = new ArrayList<DataChangeHandler>();
    protected final List<DataChange> dataChanges = new ArrayList<DataChange>();
    private TemporaryDataProvider temporaryDataProvider;

    public DataChangeLayer(IUniqueIndexLayer underlyingLayer, CellKeyHandler<?> keyHandler, boolean temporaryDataStorage) {
        this(underlyingLayer, keyHandler, temporaryDataStorage, false, true);
    }

    public DataChangeLayer(IUniqueIndexLayer underlyingLayer, CellKeyHandler<?> keyHandler, boolean temporaryDataStorage, boolean trackRowStructuralChanges) {
        this(underlyingLayer, keyHandler, temporaryDataStorage, trackRowStructuralChanges, true);
    }

    public DataChangeLayer(IUniqueIndexLayer underlyingLayer, CellKeyHandler<?> keyHandler, boolean temporaryDataStorage, boolean trackRowStructuralChanges, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.registerCommandHandlers();
        if (temporaryDataStorage && trackRowStructuralChanges) {
            LOG.warn("tracking row structural changes is not supported in temporary data storage mode");
        }
        if (temporaryDataStorage) {
            TemporaryUpdateDataChangeHandler handler = new TemporaryUpdateDataChangeHandler(this, keyHandler);
            this.registerDataChangeHandler(handler);
            this.temporaryDataProvider = handler;
        } else {
            PersistenceUpdateDataChangeHandler handler = new PersistenceUpdateDataChangeHandler(this, keyHandler);
            this.registerDataChangeHandler(handler);
            if (trackRowStructuralChanges) {
                handler.setUpdateOnVerticalChanges(false);
                this.registerDataChangeHandler(new RowInsertDataChangeHandler(this, keyHandler));
                this.registerDataChangeHandler(new RowDeleteDataChangeHandler(this, keyHandler));
            }
        }
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultDataChangeConfiguration());
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new DiscardDataChangesCommandHandler(this));
        this.registerCommandHandler(new SaveDataChangesCommandHandler(this));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (this.isCellDirty(columnPosition, rowPosition)) {
            labels.addLabelOnTop(DIRTY);
        }
        return labels;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (this.temporaryDataProvider != null && this.temporaryDataProvider.tracksDataChange(columnPosition, rowPosition)) {
            return this.temporaryDataProvider.getDataValueByPosition(columnPosition, rowPosition);
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.getColumnDiffs() == null && structuralChangeEvent.getRowDiffs() == null && structuralChangeEvent.isHorizontalStructureChanged() && structuralChangeEvent.isVerticalStructureChanged()) {
                this.clearDataChanges();
            } else {
                for (DataChangeHandler handler : this.dataChangeHandler) {
                    handler.handleStructuralChange(structuralChangeEvent);
                }
            }
        }
        super.handleLayerEvent(event);
    }

    public final void registerDataChangeHandler(DataChangeHandler handler) {
        this.dataChangeHandler.add(handler);
        if (handler instanceof ILayerCommandHandler) {
            this.registerCommandHandler((ILayerCommandHandler)((Object)handler));
        }
        if (handler instanceof ILayerEventHandler) {
            this.registerEventHandler((ILayerEventHandler)((Object)handler));
        }
    }

    public final void unregisterDataChangeHandler(DataChangeHandler handler) {
        this.dataChangeHandler.remove(handler);
        if (handler instanceof ILayerCommandHandler) {
            this.unregisterCommandHandler(((ILayerCommandHandler)((Object)handler)).getCommandClass());
        }
        if (handler instanceof ILayerEventHandler) {
            this.unregisterEventHandler((ILayerEventHandler)((Object)handler));
        }
    }

    public final List<DataChangeHandler> getDataChangeHandler() {
        return this.dataChangeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataChange(DataChange change) {
        List<DataChange> list = this.dataChanges;
        synchronized (list) {
            this.dataChanges.add(change);
        }
    }

    public List<DataChange> getDataChanges() {
        return this.dataChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardDataChanges() {
        for (DataChangeHandler dataChangeHandler : this.dataChangeHandler) {
            dataChangeHandler.disableTracking();
        }
        List<DataChange> list = this.dataChanges;
        synchronized (list) {
            ListIterator<DataChange> listIter = this.dataChanges.listIterator(this.dataChanges.size());
            while (listIter.hasPrevious()) {
                DataChange change = listIter.previous();
                change.discard(this);
            }
        }
        for (DataChangeHandler dataChangeHandler : this.dataChangeHandler) {
            dataChangeHandler.enableTracking();
        }
        this.clearDataChanges();
        this.fireLayerEvent(new DiscardDataChangesCompletedEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataChanges() {
        for (DataChangeHandler dataChangeHandler : this.dataChangeHandler) {
            dataChangeHandler.disableTracking();
        }
        List<DataChange> list = this.dataChanges;
        synchronized (list) {
            for (DataChange change : this.dataChanges) {
                change.save(this);
            }
        }
        for (DataChangeHandler dataChangeHandler : this.dataChangeHandler) {
            dataChangeHandler.enableTracking();
        }
        this.clearDataChanges();
        this.fireLayerEvent(new SaveDataChangesCompletedEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataChanges() {
        for (DataChangeHandler handler : this.dataChangeHandler) {
            handler.clearDataChanges();
        }
        List<DataChange> list = this.dataChanges;
        synchronized (list) {
            this.dataChanges.clear();
        }
    }

    public boolean isColumnDirty(int columnPosition) {
        for (DataChangeHandler handler : this.dataChangeHandler) {
            if (!handler.isColumnDirty(columnPosition)) continue;
            return true;
        }
        return false;
    }

    public boolean isRowDirty(int rowPosition) {
        for (DataChangeHandler handler : this.dataChangeHandler) {
            if (!handler.isRowDirty(rowPosition)) continue;
            return true;
        }
        return false;
    }

    public boolean isCellDirty(int columnPosition, int rowPosition) {
        for (DataChangeHandler handler : this.dataChangeHandler) {
            if (!handler.isCellDirty(columnPosition, rowPosition)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (DataChangeHandler handler : this.dataChangeHandler) {
            if (!handler.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> providedLabels = super.getProvidedLabels();
        providedLabels.add(DIRTY);
        return providedLabels;
    }
}

