/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.IDecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationSpecificFunctions;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;
import org.eclipse.papyrus.infra.services.decoration.util.StringUtils;

public class DecorationUtils {
    protected Object element;
    protected EList<EObject> eObjects;

    public DecorationUtils(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("The decorated element shall not be null");
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        this.eObjects = new BasicEList();
        this.element = element;
        if (eObject != null) {
            this.eObjects.add((Object)eObject);
        } else if (element instanceof EReferenceTreeElement) {
            for (Object child : ((EReferenceTreeElement)element).getReferedEObjectTE()) {
                if (!(child instanceof EObject)) continue;
                this.eObjects.add((Object)((EObject)child));
            }
        }
    }

    public DecorationUtils(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException("The decorated EObject shall not be null");
        }
        this.eObjects = new BasicEList();
        this.eObjects.add((Object)eObject);
    }

    public EList<EObject> getEObjects() {
        return this.eObjects;
    }

    public Map<String, Decoration> getDecorations(DecorationService decorationService) {
        return decorationService.getDecorations();
    }

    public EList<IPapyrusDecoration> getDecorations(DecorationService decorationService, boolean navigateToParents) {
        IDecorationSpecificFunctions decoUtil;
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        BasicEList foundDecorations = new BasicEList();
        HashMap<String, EList> childDecorationMap = new HashMap<String, EList>();
        if (decorations != null) {
            block0: for (Decoration decoration : decorations.values()) {
                EObject eObjectOfDecorator = decoration.getElement();
                if (this.getEObjects().contains((Object)eObjectOfDecorator)) {
                    if (decoration.getMessage() == null) {
                        decoration.setMessage("");
                    }
                    foundDecorations.add((Object)decoration);
                }
                decoUtil = DecorationSpecificFunctions.getDecorationInterface(decoration.getType());
                if (!navigateToParents || decoUtil == null || decoUtil.supportsMarkerPropagation() == IDecorationSpecificFunctions.MarkChildren.NO) continue;
                IDecorationSpecificFunctions.MarkChildren markChildren = decoUtil.supportsMarkerPropagation();
                boolean first = true;
                eObjectOfDecorator = eObjectOfDecorator.eContainer();
                while (eObjectOfDecorator != null) {
                    if (this.getEObjects().contains((Object)eObjectOfDecorator)) {
                        String type = decoration.getType();
                        EList childDecorations = (EList)childDecorationMap.get(type);
                        if (childDecorations == null) {
                            childDecorations = new BasicEList();
                            childDecorationMap.put(type, childDecorations);
                        }
                        childDecorations.add((Object)decoration);
                    }
                    eObjectOfDecorator = eObjectOfDecorator.eContainer();
                    if (markChildren != IDecorationSpecificFunctions.MarkChildren.ALL && !first) continue block0;
                    first = false;
                }
            }
        }
        for (String type : childDecorationMap.keySet()) {
            IPapyrusDecoration propagatedDecoration;
            EList childDecorations = (EList)childDecorationMap.get(type);
            if (childDecorations == null || (propagatedDecoration = (decoUtil = DecorationSpecificFunctions.getDecorationInterface(type)).markerPropagation((EList<IPapyrusDecoration>)childDecorations)) == null) continue;
            foundDecorations.add((Object)propagatedDecoration);
        }
        return foundDecorations;
    }

    @Deprecated
    public String getDecorationMessage(DecorationService decorationService) {
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        if (decorations != null) {
            Object message = "";
            for (Decoration decoration : decorations.values()) {
                EObject eObjectOfDecorator = decoration.getElement();
                if (!this.getEObjects().contains((Object)eObjectOfDecorator)) continue;
                if (((String)message).length() > 0) {
                    message = (String)message + "\n";
                }
                message = (String)message + "- " + StringUtils.stringWrap(decoration.getMessage(), 100, "\n ");
            }
            return ((String)message).length() > 0 ? message : null;
        }
        return null;
    }
}

