/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.INewPapyrusModelPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelWizardData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewModelFilePage
extends WizardNewFileCreationPage
implements INewPapyrusModelPage {
    public static final String DEFAULT_NAME = Messages.NewModelFilePage_default_diagram_name;
    public static final String DEFAULT_DIAGRAM_EXTENSION = "di";
    public static final String PAGE_ID = "NewPapyrusModel";
    private NewModelWizardData wizardData;

    public NewModelFilePage(IStructuredSelection selection, String modelKindName) {
        this(PAGE_ID, selection, modelKindName);
    }

    public NewModelFilePage(String pageId, IStructuredSelection selection, String modelKindName) {
        super(pageId, selection);
        this.setTitle(NLS.bind((String)Messages.NewModelFilePage_3, (Object)modelKindName));
        this.setDescription(NLS.bind((String)Messages.NewModelFilePage_page_desc, (Object)modelKindName));
        this.setFileExtension(DEFAULT_DIAGRAM_EXTENSION);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        String filename = this.getFileName();
        if (filename.contains("%20")) {
            filename = filename.replaceAll("%20", " ");
        }
        this.setFileName(NewModelFilePage.getUniqueFileName(this.getContainerFullPath(), filename, this.getFileExtension()));
        this.setPageComplete(this.validatePage());
    }

    @Override
    public void setNewModelWizardData(NewModelWizardData wizardData) {
        this.wizardData = wizardData;
    }

    @Override
    public NewModelWizardData getNewModelWizardData() {
        return this.wizardData;
    }

    public IStatus diagramExtensionChanged(String newExtension) {
        String currentExtension = this.getFileExtension();
        if (!currentExtension.equals(newExtension) && this.getControl() != null) {
            String newFileName = NewModelFilePage.getUniqueFileName(this.getContainerFullPath(), this.getFileName().replace(currentExtension, ""), newExtension);
            this.setFileName(newFileName);
            this.setFileExtension(newExtension);
        }
        return Status.OK_STATUS;
    }

    @Deprecated
    public IFile createFileHandle() {
        IPath containerFullPath = this.getContainerFullPath();
        String fileName = this.getFileName();
        IPath filePath = containerFullPath.append(fileName);
        return super.createFileHandle(filePath);
    }

    protected static String getUniqueFileName(IPath containerFullPath, String fileName, String extension) {
        if (extension == null) {
            extension = "";
        }
        if (containerFullPath == null) {
            containerFullPath = Path.EMPTY;
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            IPath testPath;
            IPath iPath = testPath = containerFullPath.isEmpty() ? null : containerFullPath.append(containerFullPath.lastSegment()).addFileExtension(extension);
            if (!ResourcesPlugin.getWorkspace().getRoot().exists(testPath)) {
                fileName = testPath.removeFileExtension().lastSegment();
            }
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = DEFAULT_NAME;
        }
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        IPath filePath = containerFullPath.append(fileName);
        filePath = containerFullPath.append(fileName);
        filePath = filePath.addFileExtension(extension);
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
            filePath = containerFullPath.append(fileName + ++i);
            if (extension == null) continue;
            filePath = filePath.addFileExtension(extension);
        }
        return filePath.lastSegment();
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected boolean validatePage() {
        if (this.wizardData != null) {
            this.wizardData.setModelFileName(this.getFileName());
        }
        return super.validatePage();
    }

    protected void createLinkTarget() {
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.FileChooser");
    }

    public IFile createNewFile() {
        return super.createNewFile();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = true;
        String existingModelName = "";
        for (String existingName : this.getExistingNames()) {
            if (!existingName.equalsIgnoreCase(this.getFileName())) continue;
            canFlip = false;
            existingModelName = existingName;
            break;
        }
        if (!canFlip) {
            this.setErrorMessage(Messages.NewModelFilePage_page_same_case_desc + existingModelName);
        }
        if (canFlip && (this.getContainerFullPath() == null || ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath()) == null)) {
            this.setMessage(Messages.NewModelFilePage_set_a_container);
            canFlip = false;
        }
        return canFlip && super.canFlipToNextPage();
    }

    public Collection<String> getExistingNames() {
        LinkedList<String> result = new LinkedList<String>();
        try {
            IResource rootResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath());
            if (rootResource != null) {
                if (rootResource.getType() == 4) {
                    result.addAll(this.getMembersNames(((IProject)rootResource).members()));
                }
                if (rootResource.getType() == 2) {
                    result.addAll(this.getMembersNames(((IFolder)rootResource).members()));
                }
            }
        }
        catch (CoreException ce) {
            Activator.log.error((Throwable)ce);
        }
        return result;
    }

    public Collection<String> getMembersNames(IResource[] membersArray) {
        LinkedList<String> membersList = new LinkedList<String>();
        for (IResource iResource : Arrays.asList(membersArray)) {
            membersList.add(iResource.getName());
        }
        return membersList;
    }
}

