/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcHttpTransportException;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.LimitedInputStream;
import org.xml.sax.SAXException;

public class XmlRpcLiteHttpTransport
extends XmlRpcHttpTransport {
    private static final String userAgent = USER_AGENT + " (Lite HTTP Transport)";
    private boolean ssl;
    private String hostname;
    private String host;
    private int port;
    private String uri;
    private Socket socket;
    private OutputStream output;
    private InputStream input;
    private final Map headers = new HashMap();
    private boolean responseGzipCompressed = false;
    private XmlRpcHttpClientConfig config;

    public XmlRpcLiteHttpTransport(XmlRpcClient pClient) {
        super(pClient, userAgent);
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        this.config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        URL url = this.config.getServerURL();
        this.ssl = "https".equals(url.getProtocol());
        this.hostname = url.getHost();
        int p = url.getPort();
        this.port = p < 1 ? 80 : p;
        String u = url.getFile();
        this.uri = u == null || "".equals(u) ? "/" : u;
        this.host = this.port == 80 ? this.hostname : this.hostname + ":" + this.port;
        this.headers.put("Host", this.host);
        return super.sendRequest(pRequest);
    }

    protected void setRequestHeader(String pHeader, String pValue) {
        Object value = this.headers.get(pHeader);
        if (value == null) {
            this.headers.put(pHeader, pValue);
        } else {
            ArrayList<Object> list;
            if (value instanceof String) {
                list = new ArrayList<Object>();
                list.add(value);
                this.headers.put(pHeader, list);
            } else {
                list = (ArrayList<Object>)value;
            }
            list.add(pValue);
        }
    }

    protected void close() throws XmlRpcClientException {
        IOException e;
        block11: {
            block10: {
                e = null;
                if (this.input != null) {
                    try {
                        this.input.close();
                    }
                    catch (IOException ex) {
                        e = ex;
                    }
                }
                if (this.output != null) {
                    try {
                        this.output.close();
                    }
                    catch (IOException ex) {
                        if (e == null) break block10;
                        e = ex;
                    }
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    if (e == null) break block11;
                    e = ex;
                }
            }
        }
        if (e != null) {
            throw new XmlRpcClientException("Failed to close connection: " + e.getMessage(), e);
        }
    }

    private OutputStream getOutputStream() throws XmlRpcException {
        try {
            int retries = 3;
            int delayMillis = 100;
            int tries = 0;
            while (true) {
                try {
                    this.socket = this.newSocket(this.ssl, this.hostname, this.port);
                    this.output = new BufferedOutputStream(this.socket.getOutputStream()){

                        public void close() throws IOException {
                            this.flush();
                            XmlRpcLiteHttpTransport.this.socket.shutdownOutput();
                        }
                    };
                }
                catch (ConnectException e) {
                    if (tries >= 3) {
                        throw new XmlRpcException("Failed to connect to " + this.hostname + ":" + this.port + ": " + e.getMessage(), e);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++tries;
                    continue;
                }
                break;
            }
            this.sendRequestHeaders(this.output);
            return this.output;
        }
        catch (IOException e) {
            throw new XmlRpcException("Failed to open connection to " + this.hostname + ":" + this.port + ": " + e.getMessage(), e);
        }
    }

    protected Socket newSocket(boolean pSSL, String pHostName, int pPort) throws UnknownHostException, IOException {
        if (pSSL) {
            throw new IOException("Unable to create SSL connections, use the XmlRpcLite14HttpTransportFactory.");
        }
        return new Socket(pHostName, pPort);
    }

    private byte[] toHTTPBytes(String pValue) throws UnsupportedEncodingException {
        return pValue.getBytes("US-ASCII");
    }

    private void sendHeader(OutputStream pOut, String pKey, String pValue) throws IOException {
        pOut.write(this.toHTTPBytes(pKey + ": " + pValue + "\r\n"));
    }

    private void sendRequestHeaders(OutputStream pOut) throws IOException {
        pOut.write(("POST " + this.uri + " HTTP/1.0\r\n").getBytes("US-ASCII"));
        Iterator iter = this.headers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                this.sendHeader(pOut, key, (String)value);
                continue;
            }
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                this.sendHeader(pOut, key, (String)list.get(i));
            }
        }
        pOut.write(this.toHTTPBytes("\r\n"));
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        return this.responseGzipCompressed;
    }

    protected InputStream getInputStream() throws XmlRpcException {
        byte[] buffer = new byte[2048];
        try {
            int code;
            if (this.config.getReplyTimeout() != 0) {
                this.socket.setSoTimeout(this.config.getReplyTimeout());
            }
            this.input = new BufferedInputStream(this.socket.getInputStream());
            String line = HttpUtil.readLine(this.input, buffer);
            StringTokenizer tokens = new StringTokenizer(line);
            tokens.nextToken();
            String statusCode = tokens.nextToken();
            String statusMsg = tokens.nextToken("\n\r");
            try {
                code = Integer.parseInt(statusCode);
            }
            catch (NumberFormatException e) {
                throw new XmlRpcClientException("Server returned invalid status code: " + statusCode + " " + statusMsg, null);
            }
            if (code < 200 || code > 299) {
                throw new XmlRpcHttpTransportException(code, statusMsg);
            }
            int contentLength = -1;
            while ((line = HttpUtil.readLine(this.input, buffer)) != null && !"".equals(line)) {
                if ((line = line.toLowerCase()).startsWith("content-length:")) {
                    contentLength = Integer.parseInt(line.substring("content-length:".length()).trim());
                    continue;
                }
                if (!line.startsWith("content-encoding:")) continue;
                this.responseGzipCompressed = HttpUtil.isUsingGzipEncoding(line.substring("content-encoding:".length()));
            }
            InputStream result = contentLength == -1 ? this.input : new LimitedInputStream(this.input, contentLength);
            return result;
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read server response: " + e.getMessage(), e);
        }
    }

    protected boolean isUsingByteArrayOutput(XmlRpcHttpClientConfig pConfig) {
        boolean result = super.isUsingByteArrayOutput(pConfig);
        if (!result) {
            throw new IllegalStateException("The Content-Length header is required with HTTP/1.0, and HTTP/1.1 is unsupported by the Lite HTTP Transport.");
        }
        return result;
    }

    protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException, IOException, SAXException {
        pWriter.write(this.getOutputStream());
    }
}

