/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.conversion;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef.dot.internal.ui.conversion.DotArrowShapeDecorations;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.nodes.AbstractInterpolator;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.geometry.planar.CubicCurve;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.PolyBezier;

public class DotBSplineInterpolator
extends AbstractInterpolator {
    protected ICurve computeCurve(Connection connection) {
        Point start = connection.getStartPoint();
        Point end = connection.getEndPoint();
        List controlPoints = connection.getControlPoints();
        int numControlPoints = controlPoints.size();
        if (start == null || end == null) {
            return new Line(0.0, 0.0, 0.0, 0.0);
        }
        if (numControlPoints < 4) {
            return new Line(start, end);
        }
        Point startReference = connection.getStartAnchor() instanceof DynamicAnchor ? connection.getStartPointHint() : connection.getStartPoint();
        Point endReference = connection.getEndAnchor() instanceof DynamicAnchor ? connection.getEndPointHint() : connection.getEndPoint();
        ArrayList<Object> segments = new ArrayList<Object>();
        Point p0 = (Point)controlPoints.get(0);
        if (!startReference.equals((Object)p0)) {
            segments.add(new Line(startReference, p0));
        } else {
            p0 = start;
        }
        Point p2 = null;
        int i = 1;
        while (i + 2 < numControlPoints) {
            p2 = (Point)controlPoints.get(i + 2);
            if (i + 2 == numControlPoints - 1 && endReference.equals((Object)p2)) {
                p2 = end;
            }
            segments.add(new CubicCurve(p0, (Point)controlPoints.get(i), (Point)controlPoints.get(i + 1), p2));
            i += 3;
        }
        if (!endReference.equals(p2)) {
            segments.add(new Line(p2, endReference));
        }
        return new PolyBezier(segments.toArray(new BezierCurve[0]));
    }

    protected Point getProjectionReferencePoint(DynamicAnchor anchor, AnchorKey anchorKey) {
        return (Point)((DynamicAnchor.AnchoredReferencePoint)anchor.getComputationParameter(anchorKey, DynamicAnchor.AnchoredReferencePoint.class)).get();
    }

    protected void arrangeDecoration(Node decoration, Point offset, Vector direction) {
        AffineTransform transform = new AffineTransform().translate(offset.x, offset.y);
        if (!direction.isNull()) {
            Angle angleCW = new Vector(1.0, 0.0).getAngleCW(direction);
            transform.rotate(angleCW.rad(), 0.0, 0.0);
        }
        transform.translate(this.getOffsetForNode(decoration), 0.0);
        decoration.getTransforms().setAll((Object[])new Transform[]{Geometry2FX.toFXAffine((AffineTransform)transform)});
    }

    private double getOffsetForNode(Node decoration) {
        Node firstChild;
        ObservableList children;
        if (decoration instanceof Group && !(children = ((Group)decoration).getChildren()).isEmpty() && (firstChild = (Node)children.get(0)) instanceof DotArrowShapeDecorations.IPrimitiveShape) {
            double offset = ((DotArrowShapeDecorations.IPrimitiveShape)firstChild).getOffset();
            return offset;
        }
        return 0.0;
    }
}

