/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.commands.MoveOpenableCommand;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;

public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    private static final String CHANGE_OF_RESOURCE_COMMAND = "Change of Resource";
    private static final String REORDER_COMMAND_LABEL = "Move Selected Elements in Model Explorer";

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object dropTarget) {
        EObject targetElement = EMFHelper.getEObject((Object)dropTarget);
        this.execute((EditingDomain)this.getEditingDomain(targetElement), (Command)this.getDrop(dropTarget));
        return null;
    }

    protected List<Command> getDropIntoCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject childElement, EReference eref) {
        ICommand command;
        ArrayList<Command> commandList = new ArrayList<Command>();
        MoveRequest moveRequest = new MoveRequest(targetOwner, childElement);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetOwner);
        if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)moveRequest)) != null) {
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    protected Command getDropViewCommands(TransactionalEditingDomain domain, EObject target, EObject view) {
        Resource targetNotationResource;
        ViewPrototype proto = ViewPrototype.get((EObject)view);
        if (!proto.isOwnerReassignable() || PolicyChecker.getFor((EObject)target).getOwningRuleFor(proto, target) == null || target.eIsProxy()) {
            return UnexecutableCommand.INSTANCE;
        }
        Command command = proto.getCommandChangeOwner(view, target);
        if (command != null && (targetNotationResource = this.getTargetNotationResource(target)) != null) {
            if (!targetNotationResource.equals(view.eResource())) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(command);
                list.add(new GMFtoEMFCommandWrapper((ICommand)new MoveOpenableCommand(domain, CHANGE_OF_RESOURCE_COMMAND, view, targetNotationResource)));
                return new CompoundCommand(list);
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Resource getTargetNotationResource(EObject targetOwner) {
        if (targetOwner.eResource() != null && targetOwner.eResource().getResourceSet() instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)targetOwner.eResource().getResourceSet();
            return modelSet.getAssociatedResource(targetOwner, "notation", true);
        }
        return null;
    }

    protected List<Command> getOrderChangeCommand(TransactionalEditingDomain domain, EObject targetOwner, EObject objectLocation, EObject newElement, boolean before) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        if (EcoreUtil.isAncestor((EObject)newElement, (EObject)targetOwner)) {
            return Collections.emptyList();
        }
        commandList.addAll(this.handleEObject(targetOwner, objectLocation, newElement, before));
        return commandList;
    }

    private List<Command> handleEObject(EObject targetOwner, EObject objectLocation, EObject newElement, boolean before) {
        ArrayList<EStructuralFeature> possibleEFeatures = new ArrayList<EStructuralFeature>();
        EList featureList = targetOwner.eClass().getEAllStructuralFeatures();
        ArrayList<Command> commandList = new ArrayList<Command>();
        for (EStructuralFeature eStructuralFeature : featureList) {
            EReference ref;
            if (!(eStructuralFeature instanceof EReference) || !(ref = (EReference)eStructuralFeature).isContainment() || !this.isSubClass(ref.getEType(), newElement.eClass())) continue;
            possibleEFeatures.add(eStructuralFeature);
        }
        for (EStructuralFeature eStructuralFeature : possibleEFeatures) {
            ICommand command;
            ArrayList<EObject> tmp = new ArrayList<EObject>();
            if (eStructuralFeature.isMany()) {
                tmp.addAll((Collection)targetOwner.eGet(eStructuralFeature));
                if (!newElement.equals(objectLocation)) {
                    tmp.remove(newElement);
                    int indexObject = tmp.indexOf(objectLocation);
                    if (before && indexObject != -1) {
                        tmp.add(indexObject, newElement);
                    } else if (!before && indexObject != -1) {
                        tmp.add(indexObject + 1, newElement);
                    }
                }
            } else {
                tmp.add(newElement);
            }
            SetRequest setRequest = new SetRequest(targetOwner, eStructuralFeature, tmp);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetOwner);
            if (provider == null || (command = provider.getEditCommand((IEditCommandRequest)setRequest)) == null || !command.canExecute()) continue;
            commandList.add((Command)new GMFtoEMFCommandWrapper(command));
        }
        return commandList;
    }

    protected void execute(EditingDomain domain, Command dropCommand) {
        domain.getCommandStack().execute(dropCommand);
    }

    public CompoundCommand getDrop(Object target) {
        CommonDropAdapter dropAdapter = this.getCommonDropAdapter();
        ArrayList<Command> commandList = new ArrayList<Command>();
        switch (dropAdapter.getCurrentOperation()) {
            case 2: {
                if (dropAdapter.getCurrentLocation() == 1) {
                    boolean before = true;
                    if (!(target instanceof EObjectTreeElement)) break;
                    commandList.addAll(this.getOrderChangeCommand(target, before));
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 2) {
                    boolean before = false;
                    if (!(target instanceof EObjectTreeElement)) break;
                    commandList.addAll(this.getOrderChangeCommand(target, before));
                    break;
                }
                if (dropAdapter.getCurrentLocation() == 3) {
                    if (target instanceof EObjectTreeElement) {
                        commandList.addAll(this.getDropIntoCommand(target, null));
                    }
                    if (!(target instanceof EReferenceTreeElement)) break;
                    commandList.addAll(this.getDropIntoCommand(((EReferenceTreeElement)target).getParent(), ((EReferenceTreeElement)target).getEReference()));
                    break;
                }
                dropAdapter.getCurrentLocation();
            }
        }
        return new CompoundCommand(commandList);
    }

    public boolean isSubClass(EClassifier aclass, EClass possibleSubClasse) {
        if (aclass.equals(possibleSubClasse)) {
            return true;
        }
        EList superTypeList = possibleSubClasse.getEAllSuperTypes();
        return superTypeList.contains((Object)aclass);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        CompoundCommand dropCommand = this.getDrop(target);
        if (dropCommand.canExecute()) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected List<Command> getDropIntoCommand(Object target, EReference eref) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject targetEObject = null;
        targetEObject = EMFHelper.getEObject((Object)target);
        if (targetEObject == null) {
            return result;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild = EMFHelper.getEObject(object);
                if (eObjectchild == null) continue;
                if (ViewPrototype.isViewObject((EObject)eObjectchild) && this.getEditors(targetEObject).contains(eObjectchild)) {
                    result.add(this.getDropViewCommands(this.getEditingDomain(targetEObject), targetEObject, eObjectchild));
                    continue;
                }
                result.addAll(this.getDropIntoCommand(this.getEditingDomain(targetEObject), targetEObject, eObjectchild, eref));
            }
        }
        return result;
    }

    private List<Object> getEditors(EObject context) {
        try {
            return ((IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)context)).allPages();
        }
        catch (ServiceException ex) {
            return Collections.emptyList();
        }
    }

    protected List<Command> getOrderChangeCommand(Object target, boolean before) {
        ArrayList<Command> result = new ArrayList<Command>();
        EObject dropTarget = EMFHelper.getEObject((Object)target);
        if (dropTarget == null) {
            return result;
        }
        List<Command> orderCommandList = this.getSelectionOrderCommand(dropTarget, before);
        result.addAll(orderCommandList);
        return result;
    }

    private List<EObject> geEObjectSelection() {
        ArrayList<EObject> selection = new ArrayList<EObject>();
        ISelection select = LocalSelectionTransfer.getTransfer().getSelection();
        if (select instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)select).toList();
            for (Object object : selectedElements) {
                EObject eObjectchild = EMFHelper.getEObject(object);
                if (eObjectchild == null || eObjectchild.eContainer() == null) continue;
                selection.add(eObjectchild);
            }
        }
        return selection;
    }

    private List<Command> getSelectionOrderCommand(EObject dropTarget, boolean before) {
        List<EObject> selection = this.geEObjectSelection();
        List<Command> commandList = null;
        commandList = this.isSelectionReorderAllowed(dropTarget, selection) ? this.getReorderCommands(dropTarget, before, selection) : Collections.emptyList();
        return commandList;
    }

    private List<Command> getReorderCommands(EObject dropTarget, boolean before, List<EObject> selection) {
        ArrayList<Command> separateCommand = new ArrayList<Command>();
        EObject targetContainer = dropTarget.eContainer();
        ArrayList<EObject> treatedSelection = new ArrayList<EObject>();
        for (EObject currentItem : selection) {
            if (treatedSelection.contains(currentItem)) continue;
            List<EObject> subSelection = this.getSameTypeSubSelection(currentItem, selection);
            treatedSelection.addAll(subSelection);
            if (subSelection.isEmpty()) continue;
            List<EStructuralFeature> possibleFeatures = this.getStructuralFeatureList(targetContainer, currentItem.eClass());
            for (EStructuralFeature eStructuralFeature : possibleFeatures) {
                Command requestCommand;
                Object targetStructuralFeatureOld = targetContainer.eGet(eStructuralFeature);
                SetRequest setRequest = null;
                if (eStructuralFeature.isMany()) {
                    if (targetStructuralFeatureOld instanceof EList) {
                        ArrayList<EObject> targetStructuralFeatureNewList = new ArrayList<EObject>();
                        targetStructuralFeatureNewList.addAll((Collection<EObject>)this.getNewFeatureList(dropTarget, (EList<EObject>)((EList)targetStructuralFeatureOld), subSelection, before));
                        setRequest = new SetRequest(targetContainer, eStructuralFeature, targetStructuralFeatureNewList);
                    }
                } else if (targetStructuralFeatureOld instanceof EStructuralFeature) {
                    setRequest = new SetRequest(targetContainer, eStructuralFeature, (Object)subSelection.get(0));
                }
                if (setRequest == null || (requestCommand = this.getRequestCommand(targetContainer, setRequest)) == null) continue;
                separateCommand.add(requestCommand);
            }
        }
        return separateCommand;
    }

    private Command getRequestCommand(EObject container, SetRequest setRequest) {
        ICommand command;
        Command separateCommand = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)container);
        if (provider != null && (command = provider.getEditCommand((IEditCommandRequest)setRequest)) != null && command.canExecute()) {
            command.setLabel(REORDER_COMMAND_LABEL);
            separateCommand = GMFtoEMFCommandWrapper.wrap((ICommand)command);
        }
        return separateCommand;
    }

    private List<EObject> getSameTypeSubSelection(EObject item, List<EObject> selection) {
        ArrayList<EObject> subSelection = new ArrayList<EObject>();
        EClass itemType = item.eClass();
        for (EObject current : selection) {
            EClass currentType = current.eClass();
            if (!currentType.equals(itemType)) continue;
            subSelection.add(current);
        }
        return subSelection;
    }

    private EList<EObject> getNewFeatureList(EObject dropTarget, EList<EObject> oldList, List<EObject> subSelection, boolean before) {
        BasicEList newFeatureList = new BasicEList(oldList);
        for (EObject subItem : subSelection) {
            if (!subItem.equals(dropTarget)) {
                int indexObject = newFeatureList.indexOf((Object)dropTarget);
                if (indexObject == -1) continue;
                newFeatureList.remove((Object)subItem);
                if (before) {
                    newFeatureList.add(indexObject, (Object)subItem);
                    continue;
                }
                int behindPosition = indexObject + 1 + subSelection.indexOf(subItem);
                if (behindPosition < newFeatureList.size()) {
                    newFeatureList.add(behindPosition, (Object)subItem);
                    continue;
                }
                newFeatureList.add((Object)subItem);
                continue;
            }
            newFeatureList.add((Object)subItem);
        }
        return newFeatureList;
    }

    private boolean isSelectionReorderAllowed(EObject dropTarget, List<EObject> selection) {
        return !selection.isEmpty() && dropTarget.eContainer() != null;
    }

    private List<EStructuralFeature> getStructuralFeatureList(EObject targetOwner, EClass itemSelected) {
        ArrayList<EStructuralFeature> possibleFeaturesList = new ArrayList<EStructuralFeature>();
        EList targetFeaturesList = targetOwner.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature currentFeature : targetFeaturesList) {
            EReference reference;
            if (!(currentFeature instanceof EReference) || !(reference = (EReference)currentFeature).isContainment() || !this.isSubClass(reference.getEType(), itemSelected)) continue;
            possibleFeaturesList.add(currentFeature);
        }
        return possibleFeaturesList;
    }

    protected TransactionalEditingDomain getEditingDomain(EObject context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

