/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.comparator.DoubleFilterComparator;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractNumericEditorFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.validator.DoubleFilterDataValidator;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public abstract class AbstractDoubleEditorFilterConfiguration
extends AbstractNumericEditorFilterConfiguration {
    @Override
    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        super.configureFilter(configRegistry, columnElement, configLabel);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)DoubleFilterComparator.getInstance(), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new DoubleToStringConverter(), DisplayMode.NORMAL, configLabel);
    }

    @Override
    protected IDataValidator getDataValidator(IConfigRegistry configRegistry) {
        return new DoubleFilterDataValidator((String)configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, DisplayMode.NORMAL, new String[0]), TextMatchingMode.REGULAR_EXPRESSION);
    }

    @Override
    public String getConfigurationDescription() {
        return "This editor allows to filter on double value, using >, >=, <, <=, =, <>";
    }

    private static class DoubleToStringConverter
    implements IDisplayConverter {
        private DoubleToStringConverter() {
        }

        public Object displayToCanonicalValue(Object displayValue) {
            Assert.isTrue((boolean)(displayValue instanceof String));
            Assert.isTrue((boolean)TypeUtils.isDoubleValue((String)((String)displayValue)));
            return new BigDecimal((String)displayValue).doubleValue();
        }

        public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
            ArrayList<String> values = new ArrayList<String>();
            if (canonicalValue instanceof Collection) {
                Collection col = (Collection)canonicalValue;
                for (Object object : col) {
                    if (TypeUtils.isDoubleValue((String)object.toString())) {
                        values.add(new Double(object.toString()).toString());
                        continue;
                    }
                    values.add(object.toString());
                }
            } else if (canonicalValue instanceof Double) {
                values.add(canonicalValue.toString());
            } else if (TypeUtils.isDoubleValue((String)canonicalValue.toString())) {
                values.add(new Double(canonicalValue.toString()).toString());
            } else {
                values.add(canonicalValue.toString());
            }
            return values;
        }

        public Object canonicalToDisplayValue(Object canonicalValue) {
            return null;
        }

        public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
            return null;
        }
    }
}

